/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.FirewallCooperation;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.orient.AssetAttributeStorage;
import com.sonatype.nexus.clm.internal.orient.IsAssetAuditable;
import com.sonatype.nexus.clm.internal.orient.IsAssetQuarantinable;
import com.sonatype.nexus.clm.internal.orient.OrientEvaluationSender;
import com.sonatype.nexus.clm.internal.orient.UnquarantinedComponentsUpdater;
import com.sonatype.nexus.clm.orient.AssetStateValidator;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.handlers.ContributedHandler;

@Named
@Singleton
public class FirewallContributedHandler
extends ComponentSupport
implements ContributedHandler {
    static final String ASSET_IS_QUARANTINED_ERROR_MESSAGE = "REQUESTED ITEM IS QUARANTINED";
    static final String IQ_SERVER_ERROR_MSG = "Can't obtain the quarantine status due to the error: %s. See nexus.log for more details or contact your Nexus Repository Manager administrator.";
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final IsAssetAuditable isAssetAuditable;
    private final IsAssetQuarantinable isAssetQuarantinable;
    private final FirewallCooperation cooperation;
    private final OrientEvaluationSender evaluationSender;
    private final UnquarantinedComponentsUpdater unquarantinedComponentsUpdater;
    private final IQErrorManager iqErrorManager;
    private Map<String, AssetStateValidator> assetStateValidators;

    @Inject
    public FirewallContributedHandler(RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, IsAssetAuditable isAssetAuditable, IsAssetQuarantinable isAssetQuarantinable, FirewallCooperation cooperation, OrientEvaluationSender evaluationSender, UnquarantinedComponentsUpdater unquarantinedComponentsUpdater, IQErrorManager iqErrorManager, Map<String, AssetStateValidator> assetStateValidators) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.isAssetAuditable = (IsAssetAuditable)Preconditions.checkNotNull((Object)isAssetAuditable);
        this.isAssetQuarantinable = (IsAssetQuarantinable)Preconditions.checkNotNull((Object)isAssetQuarantinable);
        this.cooperation = (FirewallCooperation)Preconditions.checkNotNull((Object)cooperation);
        this.evaluationSender = (OrientEvaluationSender)((Object)Preconditions.checkNotNull((Object)((Object)evaluationSender)));
        this.unquarantinedComponentsUpdater = (UnquarantinedComponentsUpdater)((Object)Preconditions.checkNotNull((Object)((Object)unquarantinedComponentsUpdater)));
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
        this.assetStateValidators = (Map)Preconditions.checkNotNull(assetStateValidators);
    }

    public Response handle(Context context) throws Exception {
        Response response = context.proceed();
        String action = context.getRequest().getAction();
        boolean ignoreFirewall = false;
        if (context.getAttributes().contains("IGNORE_FIREWALL")) {
            ignoreFirewall = (Boolean)context.getAttributes().get("IGNORE_FIREWALL", Boolean.class);
        }
        if (("GET".equals(action) || "HEAD".equals(action)) && response.getStatus().isSuccessful() && !ignoreFirewall) {
            Asset asset = this.getAssetFromPayload(response.getPayload());
            Repository repository = context.getRepository();
            if (this.repositoryAttributeStorage.isAuditEnabled(repository.getName()) && this.isAssetAuditable.test(asset)) {
                if (this.isAssetQuarantinable.test(repository, asset)) {
                    response = this.processQuarantineStatus(response, asset, repository);
                } else {
                    this.checkAuditStatus(repository, asset, response);
                }
            }
        }
        return response;
    }

    private Response processQuarantineStatus(Response response, Asset asset, Repository repository) {
        Preconditions.checkNotNull((Object)asset);
        Response result = response;
        try {
            QuarantineStatus quarantineStatus = this.checkQuarantineStatus(repository, asset, response);
            if (quarantineStatus != QuarantineStatus.ALLOW) {
                this.log.info("Blocked serving of quarantined asset {}:{} because quarantineStatus={}", new Object[]{repository.getName(), asset.name(), quarantineStatus});
                result = this.maybeAddReportLink(repository, asset);
                result.getAttributes().set("USE_DISPATCHED_RESPONSE", (Object)true);
                result.getHeaders().set("BYPASS_HTTP_ERRORS", new String[]{"true"});
            }
        }
        catch (IOException | RuntimeException e) {
            String errorMsg = String.format("Could not get latest quarantine status for asset %s:%s: %s", repository.getName(), asset.name(), e.getMessage());
            this.log.warn(errorMsg, (Throwable)(this.log.isDebugEnabled() ? e : null));
            this.iqErrorManager.addErrorMessage(repository.getName(), e);
            result = HttpResponses.serviceUnavailable((String)String.format(IQ_SERVER_ERROR_MSG, e.getMessage()));
        }
        return result;
    }

    private Response maybeAddReportLink(Repository repository, Asset asset) {
        String reportUrl = this.evaluationSender.getQuarantinedComponentReport(repository, asset);
        if (reportUrl == null) {
            reportUrl = this.evaluationSender.getQuarantineReport(repository);
        }
        if (reportUrl != null) {
            return HttpResponses.forbidden((String)String.format("-------------------->>> %s -------------------->>> FOR DETAILS SEE ------>>> %s <<<------", ASSET_IS_QUARANTINED_ERROR_MESSAGE, reportUrl));
        }
        return HttpResponses.forbidden((String)String.format("-------------------->>> %s <<<--------------------", ASSET_IS_QUARANTINED_ERROR_MESSAGE));
    }

    @Nullable
    private Asset getAssetFromPayload(Payload payload) {
        if (payload instanceof Content) {
            return (Asset)((Content)payload).getAttributes().get(Asset.class);
        }
        return null;
    }

    @Nullable
    private QuarantineStatus checkQuarantineStatus(Repository repository, Asset asset, Response response) throws IOException {
        QuarantineStatus status = this.assetAttributeStorage.getQuarantineStatus(asset);
        if (status == QuarantineStatus.ALLOW) {
            return status;
        }
        String repositoryName = repository.getName();
        this.iqErrorManager.reset(repositoryName);
        if (status == null) {
            status = this.sendQuarantineRequest(repository, asset, response);
        } else if (status == QuarantineStatus.DENY) {
            status = this.sendUnquarantineRequest(repository, asset);
        }
        return status;
    }

    private QuarantineStatus sendQuarantineRequest(Repository repository, Asset asset, Response response) throws IOException {
        String reason = this.isAssetNew(repository, asset, response);
        return (QuarantineStatus)((Object)this.cooperation.cooperate(String.valueOf(repository.getName()) + ':' + asset.name(), () -> Optional.ofNullable(this.assetAttributeStorage.reloadQuarantineStatus(repository, asset)), () -> this.evaluationSender.sendQuarantineRequest(asset, repository, reason)));
    }

    @Nullable
    private QuarantineStatus sendUnquarantineRequest(Repository repository, Asset asset) throws IOException {
        return (QuarantineStatus)((Object)this.cooperation.cooperate(repository.getName(), () -> Optional.ofNullable(this.assetAttributeStorage.reloadQuarantineStatus(repository, asset)), () -> {
            this.unquarantinedComponentsUpdater.requestAndUpdateUnquarantinedComponents(repository);
            return this.assetAttributeStorage.reloadQuarantineStatus(repository, asset);
        }));
    }

    private void checkAuditStatus(Repository repository, Asset asset, Response response) {
        Long assetAuditTimestamp = this.assetAttributeStorage.getAuditTimestamp(asset);
        if (assetAuditTimestamp == null) {
            DateTime blobUpdatedTime;
            String repositoryName = repository.getName();
            Long repositoryAuditTimestamp = this.repositoryAttributeStorage.getAuditTimestamp(repositoryName);
            if (repositoryAuditTimestamp != null && ((blobUpdatedTime = asset.blobUpdated()) == null || blobUpdatedTime.isBefore(repositoryAuditTimestamp.longValue()))) {
                return;
            }
            try {
                this.iqErrorManager.reset(repositoryName);
                this.sendAuditRequest(repository, asset, response);
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Problem notifying IQ server of proxied asset {}:{}: {}", new Object[]{repository.getName(), asset.name(), e.getMessage(), this.log.isDebugEnabled() ? e : null});
                this.iqErrorManager.addErrorMessage(repositoryName, e);
            }
        }
    }

    private void sendAuditRequest(Repository repository, Asset asset, Response response) throws IOException {
        String reason = this.isAssetNew(repository, asset, response);
        this.cooperation.cooperate(String.valueOf(repository.getName()) + ':' + asset.name(), () -> Optional.ofNullable(this.assetAttributeStorage.reloadAuditTimestamp(repository, asset)), () -> {
            this.evaluationSender.sendAuditRequest(asset, repository, reason);
            return null;
        });
    }

    private String isAssetNew(Repository repository, Asset asset, Response response) {
        AssetStateValidator validator = this.assetStateValidators.containsKey(repository.getFormat().getValue()) ? this.assetStateValidators.get(repository.getFormat().getValue()) : this.assetStateValidators.get("default");
        return validator.isNew(asset, response) ? "new_component" : "reevaluation";
    }
}

