/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.QuarantineStatus;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.internal.datastore.AssetAttributeStorage;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

@Named
@Singleton
public class UnquarantinedComponentsUpdater
extends ComponentSupport {
    @VisibleForTesting
    static final long ONE_HOUR = TimeUnit.HOURS.toMillis(1L);
    private final RestClientProvider restClientProvider;
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final AssetAttributeStorage assetAttributeStorage;
    private final long unquarantineUpdateMillis;

    @Inject
    public UnquarantinedComponentsUpdater(RestClientProvider restClientProvider, RepositoryAttributeStorage repositoryAttributeStorage, AssetAttributeStorage assetAttributeStorage, @Named(value="${nexus.firewall.unquarantineUpdatePeriod:-60s}") Time unquarantineUpdatePeriod) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.assetAttributeStorage = (AssetAttributeStorage)((Object)Preconditions.checkNotNull((Object)((Object)assetAttributeStorage)));
        this.unquarantineUpdateMillis = unquarantineUpdatePeriod.toMillis();
    }

    public void requestAndUpdateUnquarantinedComponents(Repository repository) throws IOException {
        Set pathnames;
        Long lastUpdateTimestamp = this.repositoryAttributeStorage.getQuarantineLastUpdateTimestamp(repository.getName());
        long timestamp = System.currentTimeMillis();
        if (lastUpdateTimestamp == null) {
            this.log.debug("Skipped request for latest unquarantined assets: quarantine is not enabled");
            return;
        }
        if (timestamp - lastUpdateTimestamp < this.unquarantineUpdateMillis) {
            this.log.debug("Skipped request for latest unquarantined assets: {}ms since last update", (Object)(timestamp - lastUpdateTimestamp));
            return;
        }
        RestClient.Repository repositoryClient = this.restClientProvider.getRepositoryClient(repository.getName());
        try {
            pathnames = repositoryClient.getUnquarantinedComponents((long)(lastUpdateTimestamp.longValue() - UnquarantinedComponentsUpdater.ONE_HOUR)).pathnames;
        }
        catch (UnsupportedOperationException e) {
            this.log.debug("IQ Server doesn't support unquarantine request: {}", (Object)e.getMessage());
            return;
        }
        for (String path : pathnames) {
            path = StringUtils.prependIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            Optional assetOpt = ((ContentFacet)repository.facet(ContentFacet.class)).assets().path(path).find();
            if (!assetOpt.isPresent()) {
                this.log.warn("Could not unquarantine stale asset {}:{}", (Object)repository.getName(), (Object)path);
                continue;
            }
            FluentAsset asset = (FluentAsset)assetOpt.get();
            QuarantineStatus quarantineStatus = this.assetAttributeStorage.getQuarantineStatus((Asset)asset);
            if (quarantineStatus == QuarantineStatus.ALLOW) continue;
            this.log.info("Released quarantined asset {}:{}", (Object)repository.getName(), (Object)path);
            this.assetAttributeStorage.setQuarantineStatus(repository, (Asset)asset, QuarantineStatus.ALLOW, timestamp);
        }
        this.repositoryAttributeStorage.setQuarantineLastUpdateTimestamp(repository.getName(), timestamp);
    }
}

