/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.IQErrorManager;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.event.asset.AssetDeletedEvent;

@Named
@Singleton
public class RemovedAssetSender
extends ComponentSupport
implements EventAware,
EventAware.Asynchronous {
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final RestClientProvider restClientProvider;
    private final IQErrorManager iqErrorManager;

    @Inject
    public RemovedAssetSender(RepositoryAttributeStorage repositoryAttributeStorage, RestClientProvider restClientProvider, IQErrorManager iqErrorManager) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.iqErrorManager = (IQErrorManager)((Object)Preconditions.checkNotNull((Object)((Object)iqErrorManager)));
    }

    @Subscribe
    @AllowConcurrentEvents
    public void onDeleteAsset(AssetDeletedEvent assetDeletedEvent) {
        String repositoryName;
        Optional repositoryOpt = assetDeletedEvent.getRepository();
        if (repositoryOpt.isPresent() && this.repositoryAttributeStorage.isAuditEnabled(repositoryName = ((Repository)repositoryOpt.get()).getName())) {
            String assetPath = assetDeletedEvent.getAsset().path();
            try {
                this.iqErrorManager.reset(repositoryName);
                this.restClientProvider.getRepositoryClient(repositoryName).removeComponent(assetPath);
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Problem notifying IQ server of removed asset {}:{}: {}", new Object[]{repositoryName, assetPath, e.getMessage(), this.log.isDebugEnabled() ? e : null});
                this.iqErrorManager.addErrorMessage(repositoryName, e);
            }
        }
    }
}

