/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.function.BiPredicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.Asset;
import org.sonatype.nexus.repository.content.AssetBlob;

@Named
@Singleton
public class IsAssetQuarantinable
implements BiPredicate<Repository, Asset> {
    private final RepositoryAttributeStorage repositoryAttributeStorage;

    @Inject
    public IsAssetQuarantinable(RepositoryAttributeStorage repositoryAttributeStorage) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
    }

    @Override
    public boolean test(Repository repository, Asset asset) {
        OffsetDateTime lastUpdated;
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)asset);
        OffsetDateTime quarantineEnabledTime = this.getQuarantineEnabledTime(repository);
        if (quarantineEnabledTime != null && (lastUpdated = (OffsetDateTime)asset.blob().map(AssetBlob::blobCreated).orElse(null)) != null) {
            OffsetDateTime quarantineThreshold = quarantineEnabledTime.plusSeconds(1L);
            return !lastUpdated.isBefore(quarantineThreshold);
        }
        return false;
    }

    private OffsetDateTime getQuarantineEnabledTime(Repository repository) {
        Long quarantineEnabledTime = this.repositoryAttributeStorage.getQuarantineEnabledTime(repository.getName());
        if (quarantineEnabledTime != null) {
            return OffsetDateTime.ofInstant(Instant.ofEpochMilli(quarantineEnabledTime), ZoneId.systemDefault());
        }
        return null;
    }
}

