/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal.datastore;

import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorageSupport;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.content.AttributeOperation;
import org.sonatype.nexus.repository.content.event.repository.ContentRepositoryAttributesEvent;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class DatastoreRepositoryAttributeStorage
extends RepositoryAttributeStorageSupport
implements EventAware {
    @Inject
    public DatastoreRepositoryAttributeStorage(RepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    protected void removeFirewallAttributes(Repository repository) {
        ((ContentFacet)repository.facet(ContentFacet.class)).attributes(AttributeOperation.REMOVE, "firewall", null);
    }

    @Override
    protected NestedAttributesMap getFirewallAttributes(Repository repository) {
        return ((ContentFacet)repository.facet(ContentFacet.class)).attributes("firewall");
    }

    @Override
    protected void saveFirewallAttributes(Repository repository, Map<String, ?> attributeChanges) {
        NestedAttributesMap firewallAttributes = this.getFirewallAttributes(repository);
        for (Map.Entry<String, ?> attribute : attributeChanges.entrySet()) {
            if (attribute.getValue() != null) {
                firewallAttributes.set(attribute.getKey(), attribute.getValue());
                continue;
            }
            firewallAttributes.remove(attribute.getKey());
        }
        ((ContentFacet)repository.facet(ContentFacet.class)).attributes(AttributeOperation.SET, "firewall", (Object)firewallAttributes.backing());
    }

    @Override
    public void setLastServerError(String repositoryName, @Nullable String serverError) {
        if (this.updateErrorState(repositoryName, serverError)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("lastServerError", serverError);
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Subscribe
    public void onContentRepositoryAttributesEvent(ContentRepositoryAttributesEvent event) {
        event.getRepository().ifPresent(repository -> this.cleanAttributesCache(repository.getName()));
    }
}

