/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.FirewallTaskManager;
import com.sonatype.nexus.clm.internal.RepositoryAuditFileWalkerProcessor;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class RepositoryAuditTask
extends TaskSupport
implements Cancelable {
    public static final String REPOSITORY_NAME_KEY = "repositoryName";
    private final RepositoryManager repositoryManager;
    private final RepositoryAuditFileWalkerProcessor repositoryAuditFileWalkerProcessor;
    private final FirewallTaskManager firewallTaskManager;
    public static final String AUDIT_TIMESTAMP_KEY = "auditTimestamp";

    @Inject
    public RepositoryAuditTask(RepositoryManager repositoryManager, RepositoryAuditFileWalkerProcessor repositoryAuditFileWalkerProcessor, FirewallTaskManager firewallTaskManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.repositoryAuditFileWalkerProcessor = (RepositoryAuditFileWalkerProcessor)Preconditions.checkNotNull((Object)repositoryAuditFileWalkerProcessor);
        this.firewallTaskManager = (FirewallTaskManager)((Object)Preconditions.checkNotNull((Object)((Object)firewallTaskManager)));
    }

    public String getRepositoryName() {
        return this.getConfiguration().getString(REPOSITORY_NAME_KEY);
    }

    public String getMessage() {
        return "Auditing components in repository " + this.getRepositoryName();
    }

    protected Object execute() throws Exception {
        try {
            String evalTimestamp = this.getConfiguration().getString(AUDIT_TIMESTAMP_KEY);
            this.log.debug("Audit started for repository {}", (Object)this.getRepositoryName());
            Repository repository = this.repositoryManager.get(this.getRepositoryName());
            Preconditions.checkArgument((repository != null ? 1 : 0) != 0, (Object)("Repository not found: " + this.getRepositoryName()));
            this.repositoryAuditFileWalkerProcessor.walk(repository, evalTimestamp);
        }
        finally {
            this.firewallTaskManager.stopAudit(this.getRepositoryName());
        }
        return null;
    }
}

