/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.AttributeUtils;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

public abstract class RepositoryAttributeStorageSupport
extends ComponentSupport
implements RepositoryAttributeStorage {
    private final RepositoryManager repositoryManager;
    private final Map<String, NestedAttributesMap> firewallAttributesCache;
    private final Set<String> repositoriesInError;

    public RepositoryAttributeStorageSupport(RepositoryManager repositoryManager) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.firewallAttributesCache = new ConcurrentHashMap<String, NestedAttributesMap>();
        this.repositoriesInError = ConcurrentHashMap.newKeySet();
    }

    @Override
    public boolean isAuditEnabled(String repositoryName) {
        return Boolean.parseBoolean(this.getAttribute(repositoryName, "auditEnabled"));
    }

    @Override
    public void setAuditEnabled(String repositoryName, boolean enable) {
        if (!enable && !this.isExisting(repositoryName)) {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
            return;
        }
        boolean wasEnabled = this.isAuditEnabled(repositoryName);
        if (wasEnabled != enable) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (enable) {
                attributes.put("auditTimestamp", Long.toString(System.currentTimeMillis()));
            } else {
                attributes.put("auditTimestamp", null);
                attributes.put("quarantineEnabledTimestamp", null);
                attributes.put("quarantineLastUpdateTimestamp", null);
                attributes.put("lastServerError", null);
            }
            attributes.put("auditEnabled", Boolean.toString(enable));
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Override
    @Nullable
    public Long getAuditTimestamp(String repositoryName) {
        return AttributeUtils.tryParse(this.getAttribute(repositoryName, "auditTimestamp"), Long::valueOf);
    }

    @Override
    public void clearAuditTimestamp(String repositoryName) {
        if (this.getAuditTimestamp(repositoryName) != null) {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("auditTimestamp", null);
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Override
    public boolean isQuarantineEnabled(String repositoryName) {
        return this.getQuarantineEnabledTime(repositoryName) != null;
    }

    @Override
    @Nullable
    public Long getQuarantineEnabledTime(String repositoryName) {
        return AttributeUtils.tryParse(this.getAttribute(repositoryName, "quarantineEnabledTimestamp"), Long::valueOf);
    }

    @Override
    public void setQuarantineEnabled(String repositoryName, boolean enable) {
        boolean wasEnabled = this.isQuarantineEnabled(repositoryName);
        if (wasEnabled != enable) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            if (enable) {
                attributes.put("quarantineEnabledTimestamp", Long.toString(System.currentTimeMillis()));
            } else {
                attributes.put("quarantineEnabledTimestamp", null);
                attributes.put("quarantineLastUpdateTimestamp", null);
            }
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Override
    @Nullable
    public Long getQuarantineLastUpdateTimestamp(String repositoryName) {
        Long timestamp = AttributeUtils.tryParse(this.getAttribute(repositoryName, "quarantineLastUpdateTimestamp"), Long::valueOf);
        return timestamp != null ? timestamp : this.getQuarantineEnabledTime(repositoryName);
    }

    @Override
    public void setQuarantineLastUpdateTimestamp(String repositoryName, long timestamp) {
        if (this.isQuarantineEnabled(repositoryName)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("quarantineLastUpdateTimestamp", Long.toString(timestamp));
            this.saveAttributes(repositoryName, attributes);
        }
    }

    @Override
    @Nullable
    public String getLastServerError(String repositoryName) {
        return this.getAttribute(repositoryName, "lastServerError");
    }

    @Override
    public void clearLastServerError(String repositoryName) {
        this.setLastServerError(repositoryName, null);
    }

    @Override
    public void clearAttributes(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            this.removeFirewallAttributes(repository);
        } else {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
        }
    }

    @Override
    public boolean hasErrors() {
        return !this.repositoriesInError.isEmpty();
    }

    public void cleanAttributesCache(String repositoryName) {
        this.firewallAttributesCache.remove(repositoryName);
    }

    protected boolean updateErrorState(String repositoryName, @Nullable Object serverError) {
        if (serverError != null) {
            return this.repositoriesInError.add(repositoryName);
        }
        return this.repositoriesInError.remove(repositoryName);
    }

    protected void saveAttributes(String repositoryName, Map<String, ?> attributeChanges) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            this.saveFirewallAttributes(repository, attributeChanges);
        } else {
            this.firewallAttributesCache.remove(repositoryName);
            this.repositoriesInError.remove(repositoryName);
        }
    }

    protected abstract void removeFirewallAttributes(Repository var1);

    protected abstract NestedAttributesMap getFirewallAttributes(Repository var1);

    protected abstract void saveFirewallAttributes(Repository var1, Map<String, ?> var2);

    private boolean isExisting(String repositoryName) {
        return this.repositoryManager.get(repositoryName) != null;
    }

    @Nullable
    private String getAttribute(String repositoryName, String key) {
        NestedAttributesMap attributesCache = this.getAttributesCache(repositoryName);
        return attributesCache != null ? (String)attributesCache.get(key, String.class) : null;
    }

    @Nullable
    private NestedAttributesMap getAttributesCache(String repositoryName) {
        Repository repository = this.repositoryManager.get(repositoryName);
        if (repository != null) {
            return this.firewallAttributesCache.computeIfAbsent(repositoryName, name -> {
                NestedAttributesMap firewallAttributes = this.getFirewallAttributes(repository);
                this.updateErrorState(repositoryName, firewallAttributes.get("lastServerError"));
                return firewallAttributes;
            });
        }
        return null;
    }
}

