/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.nexus.clm.internal.RepositoryAttributeStorage;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import java.io.IOException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class IQErrorManager
extends ComponentSupport {
    private final RepositoryAttributeStorage repositoryAttributeStorage;
    private final RestClientProvider restClientProvider;

    @Inject
    public IQErrorManager(RepositoryAttributeStorage repositoryAttributeStorage, RestClientProvider restClientProvider) {
        this.repositoryAttributeStorage = (RepositoryAttributeStorage)Preconditions.checkNotNull((Object)repositoryAttributeStorage);
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
    }

    public void verifyConnection(String repositoryName) {
        try {
            this.sendRepositoryState(repositoryName);
        }
        catch (IOException | RuntimeException e) {
            this.log.warn("Problem registering repository {} with IQ server: {}", new Object[]{repositoryName, e.getMessage(), this.log.isDebugEnabled() ? e : null});
            this.addErrorMessage(repositoryName, e);
        }
    }

    public void reset(String repositoryName) throws IOException {
        if (this.repositoryAttributeStorage.getLastServerError(repositoryName) != null) {
            this.sendRepositoryState(repositoryName);
        }
    }

    private void sendRepositoryState(String repositoryName) throws IOException {
        RestClient.Repository client = this.restClientProvider.getRepositoryClient(repositoryName);
        boolean auditEnabled = this.repositoryAttributeStorage.isAuditEnabled(repositoryName);
        client.setEnabled(auditEnabled);
        if (auditEnabled) {
            client.setQuarantine(this.repositoryAttributeStorage.isQuarantineEnabled(repositoryName));
        }
        this.repositoryAttributeStorage.clearLastServerError(repositoryName);
    }

    public void addErrorMessage(String repositoryName, Exception e) {
        String message = "Error communicating with IQ Server";
        if (StringUtils.isNotEmpty((String)e.getMessage())) {
            message = String.valueOf(message) + ": " + e.getMessage();
        }
        if (!message.endsWith(".")) {
            message = String.valueOf(message) + '.';
        }
        message = String.valueOf(message) + " Please check the logs for details.";
        try {
            this.repositoryAttributeStorage.setLastServerError(repositoryName, message);
        }
        catch (Exception suppressed) {
            e.addSuppressed(suppressed);
        }
    }

    public void addErrorMessage(String repositoryName) {
        try {
            this.repositoryAttributeStorage.setLastServerError(repositoryName, "Error communicating with IQ Server. Please check the logs for details.");
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public String getErrorMessage(String repositoryName) {
        return this.repositoryAttributeStorage.getLastServerError(repositoryName);
    }
}

