/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.component.FirewallIgnorePatterns;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsStore;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class FirewallIgnorePatternsUpdater
extends ComponentSupport
implements Runnable {
    private static final int MINIMUM_UPDATE_PERIOD_MILLIS = 60000;
    private final RestClientProvider restClientProvider;
    private final FirewallIgnorePatternsStore firewallIgnorePatternsStore;
    private long lastUpdated;

    @Inject
    public FirewallIgnorePatternsUpdater(RestClientProvider restClientProvider, FirewallIgnorePatternsStore firewallIgnorePatternsStore) {
        this.restClientProvider = (RestClientProvider)Preconditions.checkNotNull((Object)restClientProvider);
        this.firewallIgnorePatternsStore = (FirewallIgnorePatternsStore)Preconditions.checkNotNull((Object)firewallIgnorePatternsStore);
    }

    @Override
    public synchronized void run() {
        long requestTime = System.currentTimeMillis();
        if (requestTime - this.lastUpdated >= 60000L) {
            try {
                this.log.debug("Requesting latest ignore patterns from IQ server");
                FirewallIgnorePatterns patterns = this.restClientProvider.getBaseClient().getFirewallIgnorePatterns();
                this.firewallIgnorePatternsStore.save(patterns.regexpsByRepositoryFormat);
                this.lastUpdated = requestTime;
            }
            catch (UnsupportedOperationException e) {
                this.lastUpdated = requestTime;
                this.log.debug("IQ Server doesn't support ignore patterns request: {}", (Object)e.getMessage());
            }
            catch (IOException | RuntimeException e) {
                this.log.warn("Could not update to latest ignore patterns from IQ Server, retrying later: {}", (Object)e.getMessage(), (Object)(this.log.isDebugEnabled() ? e : null));
            }
        } else {
            this.log.debug("Skipped request for latest ignore patterns: {}ms since last update", (Object)(requestTime - this.lastUpdated));
        }
    }
}

