/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsUpdater;
import java.util.Comparator;
import java.util.Date;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.scheduling.TaskConfiguration;
import org.sonatype.nexus.scheduling.TaskInfo;
import org.sonatype.nexus.scheduling.TaskScheduler;
import org.sonatype.nexus.scheduling.schedule.Schedule;

@Named
@Singleton
public class FirewallIgnorePatternsTaskManager
extends ComponentSupport {
    private static final String TASK_CONFIGURATION_NAME = "Firewall Ignore Patterns";
    private final TaskScheduler taskScheduler;
    private final FirewallIgnorePatternsUpdater ignorePatternsUpdater;

    @Inject
    public FirewallIgnorePatternsTaskManager(TaskScheduler taskScheduler, FirewallIgnorePatternsUpdater ignorePatternsUpdater) {
        this.taskScheduler = (TaskScheduler)Preconditions.checkNotNull((Object)taskScheduler);
        this.ignorePatternsUpdater = (FirewallIgnorePatternsUpdater)Preconditions.checkNotNull((Object)ignorePatternsUpdater);
    }

    public void startPeriodically() {
        this.ignorePatternsUpdater.run();
        if (!this.isScheduled()) {
            String cron = "0 0 */6 ? * *";
            this.log.debug("Starting periodic update of {} for {}", (Object)TASK_CONFIGURATION_NAME, (Object)cron);
            this.taskScheduler.scheduleTask(this.getConfiguration(), (Schedule)this.taskScheduler.getScheduleFactory().cron(new Date(), cron));
        }
        this.removeDuplicates();
    }

    private TaskConfiguration getConfiguration() {
        TaskConfiguration configuration = this.taskScheduler.createTaskConfigurationInstance("firewall.ignore-patterns");
        configuration.setName(TASK_CONFIGURATION_NAME);
        return configuration;
    }

    private boolean isScheduled() {
        return this.getFirewallIgnorePatternsTasksStream().findAny().isPresent();
    }

    public void stop() {
        this.log.debug("Stopping periodic update of {}", (Object)TASK_CONFIGURATION_NAME);
        this.getFirewallIgnorePatternsTasksStream().forEach(taskInfo -> {
            this.log.debug("Removing {} update task with id {}", (Object)TASK_CONFIGURATION_NAME, (Object)taskInfo.getId());
            taskInfo.remove();
        });
    }

    void removeDuplicates() {
        this.getFirewallIgnorePatternsTasksStream().sorted(Comparator.comparing(TaskInfo::getId)).skip(1L).forEach(taskInfo -> {
            this.log.debug("Removing {} update task with id {}", (Object)TASK_CONFIGURATION_NAME, (Object)taskInfo.getId());
            taskInfo.remove();
        });
    }

    private Stream<TaskInfo> getFirewallIgnorePatternsTasksStream() {
        return this.taskScheduler.listsTasks().stream().filter(taskInfo -> "firewall.ignore-patterns".equals(taskInfo.getConfiguration().getTypeId()));
    }
}

