/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatterns;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsDAO;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsData;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsEvent;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsStore;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.datastore.ConfigStoreSupport;
import org.sonatype.nexus.datastore.api.DataSessionSupplier;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="mybatis")
@Singleton
public class FirewallIgnorePatternsStoreImpl
extends ConfigStoreSupport<FirewallIgnorePatternsDAO>
implements FirewallIgnorePatternsStore {
    private static final Map<String, List<String>> DEFAULT_PATTERNS = ImmutableMap.of((Object)"maven2", (Object)ImmutableList.of((Object)".*\\.sha1", (Object)".*\\.md5", (Object)".*\\.asc", (Object)".*\\.pom", (Object)".*maven-metadata\\.xml", (Object)".*archetype-catalog\\.xml"));
    private final EventManager eventManager;

    @Inject
    public FirewallIgnorePatternsStoreImpl(DataSessionSupplier sessionSupplier, EventManager eventManager) {
        super(sessionSupplier);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    @Transactional
    public Map<String, List<String>> load() {
        return ((FirewallIgnorePatternsDAO)this.dao()).get().map(FirewallIgnorePatternsData::getRegexpsByFormat).orElse(DEFAULT_PATTERNS);
    }

    @Override
    public void save(Map<String, List<String>> regexpsByFormat) {
        FirewallIgnorePatternsData ignorePatterns = new FirewallIgnorePatternsData();
        ignorePatterns.setRegexpsByFormat(regexpsByFormat);
        this.doSave(ignorePatterns);
        this.postEvent(ignorePatterns);
    }

    @Transactional
    protected void doSave(FirewallIgnorePatternsData ignorePatterns) {
        ((FirewallIgnorePatternsDAO)this.dao()).set(ignorePatterns);
    }

    private void postEvent(final FirewallIgnorePatterns ignorePatterns) {
        this.eventManager.post((Object)new FirewallIgnorePatternsEvent(){

            @Override
            public boolean isLocal() {
                return true;
            }

            @Override
            public Map<String, List<String>> getRegexpsByFormat() {
                return ignorePatterns.getRegexpsByFormat();
            }
        });
    }
}

