/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.internal;

import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsData;
import com.sonatype.nexus.clm.internal.FirewallIgnorePatternsStore;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.supportzip.ExportConfigData;
import org.sonatype.nexus.supportzip.ImportData;
import org.sonatype.nexus.supportzip.datastore.JsonExporter;

@Named(value="firewallIgnorePatternsExport")
@Singleton
public class FirewallIgnorePatternsExport
extends JsonExporter
implements ExportConfigData,
ImportData {
    private final FirewallIgnorePatternsStore store;

    @Inject
    public FirewallIgnorePatternsExport(FirewallIgnorePatternsStore store) {
        this.store = store;
    }

    public void export(File file) throws IOException {
        this.log.debug("Export FirewallIgnorePatterns data to {}", (Object)file);
        FirewallIgnorePatternsData ignorePatterns = new FirewallIgnorePatternsData();
        ignorePatterns.setRegexpsByFormat(this.store.load());
        this.exportObjectToJson(ignorePatterns, file);
    }

    public void restore(File file) throws IOException {
        this.log.debug("Restoring FirewallIgnorePatterns data from {}", (Object)file);
        Optional ignorePatterns = this.importObjectFromJson(file, FirewallIgnorePatternsData.class);
        ignorePatterns.ifPresent(data -> this.store.save(data.getRegexpsByFormat()));
    }
}

