/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.firewall;

import com.google.common.eventbus.Subscribe;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataList;
import com.sonatype.clm.dto.model.component.RepositoryComponentEvaluationDataRequestList;
import com.sonatype.nexus.clm.internal.RestClientProvider;
import com.sonatype.nexus.clm.vulnerability.service.ClmService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentDetailService;
import com.sonatype.nexus.clm.vulnerability.service.ComponentVersionsService;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.firewall.event.ComponentDetailsRequest;
import org.sonatype.nexus.repository.firewall.event.ComponentVersionsRequest;
import org.sonatype.nexus.repository.firewall.event.QuarantineComponentsRequestEvent;
import org.sonatype.nexus.repository.vulnerability.exceptions.InternalException;

@Named
@Singleton
public class FirewallComponentDetailsListener
extends ComponentSupport
implements EventAware {
    private final ComponentDetailService componentDetailService;
    private final ComponentVersionsService componentVersionsService;
    private final Provider<ClmService> clmServiceProvider;
    private final RestClientProvider restClientProvider;

    @Inject
    public FirewallComponentDetailsListener(ComponentDetailService componentDetailService, ComponentVersionsService componentVersionsService, Provider<ClmService> clmServiceProvider, RestClientProvider restClientProvider) {
        this.componentDetailService = componentDetailService;
        this.componentVersionsService = componentVersionsService;
        this.clmServiceProvider = clmServiceProvider;
        this.restClientProvider = restClientProvider;
    }

    @Subscribe
    public void on(ComponentDetailsRequest request) {
        try {
            Map<String, Date> catalogDates = this.componentDetailService.getCatalogDates((ClmService)this.clmServiceProvider.get(), request.getPackageUrls());
            this.log.trace("Catalog dates for component {} versions => {}", (Object)request.getName(), catalogDates);
            request.getResult().complete(catalogDates);
        }
        catch (InternalException e) {
            this.log.error("Error getting component details for '{}'", (Object)request.getName(), (Object)e);
            request.getResult().completeExceptionally(e);
        }
    }

    @Subscribe
    public void on(ComponentVersionsRequest request) {
        try {
            List<String> versions = this.componentVersionsService.getVersions((ClmService)this.clmServiceProvider.get(), request.getPackageUrl());
            this.log.trace("Versions component {} versions => {}", (Object)request.getPackageUrl(), versions);
            request.getResult().complete(versions);
        }
        catch (InternalException e) {
            this.log.error("Error getting component details for '{}'", (Object)request.getPackageUrl(), (Object)e);
            request.getResult().completeExceptionally(e);
        }
    }

    @Subscribe
    public void on(QuarantineComponentsRequestEvent request) {
        try {
            RepositoryComponentEvaluationDataRequestList requestList = this.newRequestList(request.getRepository().getFormat(), request.getComponents(), "reevaluation");
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluating component metadata for {}", request.getComponents().stream().map(QuarantineComponentsRequestEvent.FirewallComponent::getPath).collect(Collectors.toList()));
            }
            RepositoryComponentEvaluationDataList result = this.restClientProvider.getRepositoryClient(request.getRepository().getName()).evaluateComponentMetadata(requestList);
            request.getResult().complete(this.filterQuarantined(requestList, result));
        }
        catch (IOException e) {
            this.log.error("Error evaluating component metadata for {}", request.getComponents().stream().map(QuarantineComponentsRequestEvent.FirewallComponent::getPath).collect(Collectors.toList()), (Object)e);
            request.getResult().completeExceptionally(e);
        }
    }

    private RepositoryComponentEvaluationDataRequestList newRequestList(Format format, List<QuarantineComponentsRequestEvent.FirewallComponent> components, String cause) {
        RepositoryComponentEvaluationDataRequestList requestList = new RepositoryComponentEvaluationDataRequestList(cause);
        for (QuarantineComponentsRequestEvent.FirewallComponent component : components) {
            requestList.components.add(new RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest(format.getValue(), component.getPath(), component.getHash()));
        }
        return requestList;
    }

    private List<String> filterQuarantined(RepositoryComponentEvaluationDataRequestList requestList, RepositoryComponentEvaluationDataList result) {
        List<String> quarantinedPaths = result.componentEvalResults.stream().filter(data -> data.quarantine).map(data -> ((RepositoryComponentEvaluationDataRequestList.RepositoryComponentEvaluationDataRequest)repositoryComponentEvaluationDataRequestList.components.get((int)data.requestIndex)).pathname).collect(Collectors.toList());
        return quarantinedPaths;
    }
}

