/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.api;

import com.sonatype.nexus.clm.api.IqConnectionVerificationXo;
import com.sonatype.nexus.clm.api.IqConnectionXo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@Api(value="Manage IQ server configuration")
public interface IqApiResourceDoc {
    @ApiOperation(value="Get IQ server configuration")
    @ApiResponses(value={@ApiResponse(code=200, message="IQ server configuration returned")})
    public IqConnectionXo getConfiguration();

    @ApiOperation(value="Update IQ server configuration")
    @ApiResponses(value={@ApiResponse(code=204, message="IQ server configuration has been updated")})
    public void updateConfiguration(@NotNull @Valid IqConnectionXo var1);

    @ApiOperation(value="Verify IQ server connection")
    @ApiResponses(value={@ApiResponse(code=200, message="Connection verification complete, check response body for result")})
    public IqConnectionVerificationXo verifyConnection();

    @ApiOperation(value="Enable IQ server")
    @ApiResponses(value={@ApiResponse(code=204, message="IQ server has been enabled"), @ApiResponse(code=400, message="IQ server connection not configured")})
    public void enableIq();

    @ApiOperation(value="Disable IQ server")
    @ApiResponses(value={@ApiResponse(code=204, message="IQ server has been disabled"), @ApiResponse(code=400, message="IQ server connection not configured")})
    public void disableIq();
}

