/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm.api;

import com.google.common.base.Preconditions;
import com.sonatype.clm.dto.model.application.ApplicationSummary;
import com.sonatype.insight.rm.rest.RestClient;
import com.sonatype.insight.rm.rest.RestClientConfiguration;
import com.sonatype.insight.rm.rest.RestClientFactory;
import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.ClmConfiguration;
import com.sonatype.nexus.clm.ClmConnector;
import com.sonatype.nexus.clm.api.IqApiResourceDoc;
import com.sonatype.nexus.clm.api.IqConnectionVerificationXo;
import com.sonatype.nexus.clm.api.IqConnectionXo;
import java.io.IOException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.rapture.PasswordPlaceholder;
import org.sonatype.nexus.rest.Resource;
import org.sonatype.nexus.rest.WebApplicationMessageException;
import org.sonatype.nexus.validation.Validate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class IqApiResource
extends ComponentSupport
implements Resource,
IqApiResourceDoc {
    private ClmConnector clmConnector;

    @Inject
    public IqApiResource(ClmConnector clmConnector) {
        this.clmConnector = (ClmConnector)((Object)Preconditions.checkNotNull((Object)((Object)clmConnector)));
    }

    @Override
    @GET
    @RequiresPermissions(value={"nexus:settings:read"})
    public IqConnectionXo getConfiguration() {
        if (this.clmConnector.isConfigured()) {
            ClmConfiguration clmConfiguration = this.clmConnector.getConfiguration();
            IqConnectionXo iqConnectionXo = new IqConnectionXo();
            iqConnectionXo.setEnabled(this.clmConnector.isActive());
            iqConnectionXo.setUrl(clmConfiguration.getUrl());
            iqConnectionXo.setAuthenticationType(clmConfiguration.getAuthenticationType().name());
            iqConnectionXo.setUseTrustStoreForUrl(clmConfiguration.getUseTrustStore());
            iqConnectionXo.setTimeoutSeconds(clmConfiguration.getTimeout());
            iqConnectionXo.setProperties(clmConfiguration.getPropertiesAsString());
            iqConnectionXo.setShowLink(clmConfiguration.getShowLink());
            if (ClmAuthenticationType.USER == clmConfiguration.getAuthenticationType()) {
                iqConnectionXo.setUsername(clmConfiguration.getUsername());
                iqConnectionXo.setPassword(PasswordPlaceholder.get());
            }
            return iqConnectionXo;
        }
        return new IqConnectionXo();
    }

    @Override
    @PUT
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    @Validate
    public void updateConfiguration(@NotNull @Valid IqConnectionXo iqConnectionXo) {
        ClmConfiguration clmConfiguration = new ClmConfiguration().withUrl(iqConnectionXo.getUrl()).withUseTrustStore(iqConnectionXo.getUseTrustStoreForUrl()).withShowLink(iqConnectionXo.getShowLink()).withAuthenticationType(ClmAuthenticationType.valueOf(iqConnectionXo.getAuthenticationType(), ClmAuthenticationType.USER));
        if (ClmAuthenticationType.USER == clmConfiguration.getAuthenticationType()) {
            clmConfiguration.withUsername(iqConnectionXo.getUsername());
            if (PasswordPlaceholder.isNot((String)iqConnectionXo.getPassword())) {
                clmConfiguration.withPassword(iqConnectionXo.getPassword());
            }
        }
        if (iqConnectionXo.getTimeoutSeconds() != null) {
            clmConfiguration.withTimeout(iqConnectionXo.getTimeoutSeconds());
        }
        if (iqConnectionXo.getProperties() != null) {
            clmConfiguration.withProperties(iqConnectionXo.getProperties());
        }
        this.clmConnector.configure(clmConfiguration, iqConnectionXo.getEnabled());
    }

    @Override
    @POST
    @Path(value="/verify-connection")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:read"})
    public IqConnectionVerificationXo verifyConnection() {
        ClmConfiguration configuration = this.clmConnector.getConfiguration();
        if (configuration == null) {
            return new IqConnectionVerificationXo(false, "IQ Server is not configured");
        }
        RestClientConfiguration restConfiguration = ClmAuthenticationType.PKI.equals((Object)configuration.getAuthenticationType()) ? this.clmConnector.getRestConfiguration(configuration.getUrl(), configuration.getUseTrustStore(), configuration.getTimeout()) : this.clmConnector.getRestConfiguration(configuration.getUrl(), configuration.getUseTrustStore(), configuration.getTimeout(), configuration.getUsername(), configuration.getPassword());
        RestClient.Base restClient = new RestClientFactory().forConfiguration(restConfiguration);
        try {
            restClient.validateConfiguration();
            String applications = restClient.getApplicationsForApplicationEvaluation().getApplicationSummaries().stream().map(ApplicationSummary::getName).collect(Collectors.joining(", ", "IQ Server reported applications: ", ""));
            return new IqConnectionVerificationXo(true, applications);
        }
        catch (IOException e) {
            this.log.debug("Failed to verify connection to  IQ Server", (Throwable)e);
            return new IqConnectionVerificationXo(false, e.getMessage());
        }
    }

    @Override
    @POST
    @Path(value="/enable")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    public void enableIq() {
        this.checkIqIsConfigured();
        this.clmConnector.configure(this.clmConnector.getConfiguration(), true);
    }

    @Override
    @POST
    @Path(value="/disable")
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:settings:update"})
    public void disableIq() {
        this.checkIqIsConfigured();
        this.clmConnector.configure(this.clmConnector.getConfiguration(), false);
    }

    private void checkIqIsConfigured() {
        if (!this.clmConnector.isConfigured()) {
            throw new WebApplicationMessageException(Response.Status.BAD_REQUEST, (Object)"\"IQ Server is not configured\"", "application/json");
        }
    }
}

