/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

public class FirewallAuditCapabilityConfiguration
extends CapabilityConfigurationSupport {
    public static final String REPOSITORY_NAME = "repository";
    public static final String REPOSITORY_QUARANTINE = "quarantine";
    private String repositoryName;
    private boolean quarantineEnabled = false;

    public FirewallAuditCapabilityConfiguration() {
    }

    public FirewallAuditCapabilityConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.repositoryName = properties.get(REPOSITORY_NAME);
        this.quarantineEnabled = this.parseBoolean(properties.get(REPOSITORY_QUARANTINE), false);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public FirewallAuditCapabilityConfiguration withRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
        return this;
    }

    public boolean isQuarantineEnabled() {
        return this.quarantineEnabled;
    }

    public FirewallAuditCapabilityConfiguration withQuarantineEnabled(boolean quarantineEnabled) {
        this.quarantineEnabled = quarantineEnabled;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        props.put(REPOSITORY_NAME, this.repositoryName);
        props.put(REPOSITORY_QUARANTINE, Boolean.toString(this.quarantineEnabled));
        return props;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + "{" + "repositoryName='" + this.repositoryName + "'}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FirewallAuditCapabilityConfiguration)) {
            return false;
        }
        FirewallAuditCapabilityConfiguration other = (FirewallAuditCapabilityConfiguration)((Object)obj);
        return Objects.equals(this.repositoryName, other.getRepositoryName()) && Objects.equals(this.quarantineEnabled, other.isQuarantineEnabled());
    }

    public int hashCode() {
        return Objects.hash(this.repositoryName, this.quarantineEnabled);
    }
}

