/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.clm;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.sonatype.nexus.clm.ClmAuthenticationType;
import com.sonatype.nexus.clm.validator.ClmAuthentication;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang.StringUtils;
import org.hibernate.validator.constraints.URL;
import org.sonatype.nexus.capability.CapabilityConfigurationSupport;

@ClmAuthentication
public class ClmConfiguration
extends CapabilityConfigurationSupport {
    public static final String AUTHENTICATION_TYPE = "authenticationType";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String URL = "url";
    public static final String TIMEOUT = "timeout";
    public static final String PROPERTIES = "properties";
    public static final String USE_TRUST_STORE = "useTrustStore";
    public static final String SHOW_LINK = "showLink";
    private static final String LINE_SEP = System.getProperty("line.separator");
    @NotBlank
    @URL
    private String url;
    private boolean useTrustStore;
    @Min(value=0L)
    private @Min(value=0L) Integer timeout;
    private Properties properties;
    private String username;
    private String password;
    private ClmAuthenticationType authenticationType;
    private boolean showLink;

    public ClmConfiguration() {
    }

    public ClmConfiguration(Map<String, String> properties) {
        Preconditions.checkNotNull(properties);
        this.url = (String)Preconditions.checkNotNull((Object)properties.get(URL));
        this.useTrustStore = this.parseBoolean(properties.get(USE_TRUST_STORE), false);
        this.authenticationType = ClmAuthenticationType.valueOf(properties.get(AUTHENTICATION_TYPE), ClmAuthenticationType.USER);
        this.username = properties.get(USERNAME);
        this.password = StringUtils.isNotBlank((String)this.username) ? properties.get(PASSWORD) : null;
        this.timeout = this.parseTimeout(properties.get(TIMEOUT));
        this.properties = this.parseProperties(properties.get(PROPERTIES));
        this.showLink = this.parseBoolean(properties.get(SHOW_LINK), true);
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getUseTrustStore() {
        return this.useTrustStore;
    }

    public ClmAuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public boolean getShowLink() {
        return this.showLink;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getPropertiesAsString() {
        if (this.properties == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
            builder.append(Joiner.on((String)"=").join(entry.getKey(), entry.getValue(), new Object[0]));
            builder.append(LINE_SEP);
        }
        return builder.toString();
    }

    public ClmConfiguration withAuthenticationType(ClmAuthenticationType authenticationType) {
        this.authenticationType = (ClmAuthenticationType)((Object)Preconditions.checkNotNull((Object)((Object)authenticationType)));
        return this;
    }

    public ClmConfiguration withUsername(String username) {
        this.username = username;
        return this;
    }

    public ClmConfiguration withPassword(String password) {
        this.password = password;
        return this;
    }

    public ClmConfiguration withUrl(String url) {
        this.url = url;
        return this;
    }

    public ClmConfiguration withUseTrustStore(boolean useTrustStore) {
        this.useTrustStore = useTrustStore;
        return this;
    }

    public ClmConfiguration withTimeout(Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    public ClmConfiguration withTimeout(String timeout) {
        return this.withTimeout(this.parseTimeout(timeout));
    }

    public ClmConfiguration withProperties(Properties properties) {
        this.properties = properties;
        return this;
    }

    public ClmConfiguration withProperties(String properties) {
        return this.withProperties(this.parseProperties(properties));
    }

    public ClmConfiguration withShowLink(boolean showLink) {
        this.showLink = showLink;
        return this;
    }

    public Map<String, String> asMap() {
        HashMap props = Maps.newHashMap();
        if (this.url != null) {
            props.put(URL, this.url);
        }
        props.put(USE_TRUST_STORE, String.valueOf(this.useTrustStore));
        if (this.authenticationType != null) {
            props.put(AUTHENTICATION_TYPE, this.authenticationType.name());
        }
        if (this.timeout != null) {
            props.put(TIMEOUT, this.timeout.toString());
        }
        if (this.properties != null) {
            props.put(PROPERTIES, this.getPropertiesAsString());
        }
        if (this.username != null) {
            props.put(USERNAME, this.username);
        }
        if (this.password != null) {
            props.put(PASSWORD, this.password);
        }
        props.put(SHOW_LINK, String.valueOf(this.showLink));
        return props;
    }

    private Integer parseTimeout(String value) {
        if (value != null) {
            return Integer.valueOf(value);
        }
        return null;
    }

    private Properties parseProperties(String value) {
        Properties properties = new Properties();
        if (value != null) {
            try {
                properties.load(new StringReader(value));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return properties;
    }

    public String toString() {
        return String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + '{' + "url=" + this.url + ", useTrustStore=" + this.useTrustStore + ", authenticationType=" + (this.authenticationType != null ? this.authenticationType.name() : "not-set") + (ClmAuthenticationType.USER == this.authenticationType ? ", username=" + this.username : "") + ", timeout=" + this.timeout + ", properties=" + this.properties + ", showLink=" + this.showLink + '}';
    }
}

