/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.orient.console;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.compression.OCompression;
import com.orientechnologies.orient.core.compression.OCompressionFactory;
import java.util.logging.LogManager;
import org.eclipse.sisu.wire.WireModule;
import org.sonatype.nexus.crypto.CryptoHelper;
import org.sonatype.nexus.crypto.PbeCipherFactory;
import org.sonatype.nexus.crypto.internal.CryptoHelperImpl;
import org.sonatype.nexus.crypto.internal.PbeCipherFactoryImpl;
import org.sonatype.nexus.orient.entity.ConflictHook;
import org.sonatype.nexus.orient.internal.PbeCompression;

public class Main {
    private Main() {
    }

    public static void main(String[] args) throws Exception {
        LogManager.getLogManager().readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        OLogManager.instance().installCustomFormatter();
        Injector injector = Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{binder -> {
            binder.bind(PbeCipherFactory.class).to(PbeCipherFactoryImpl.class);
            binder.bind(CryptoHelper.class).to(CryptoHelperImpl.class);
            binder.bind(PbeCompression.class);
        }})});
        OCompressionFactory.INSTANCE.register((OCompression)injector.getInstance(PbeCompression.class));
        Orient.instance().getRecordConflictStrategy().registerImplementation((Object)"ConflictHook", (Object)new ConflictHook(false));
        OConsoleDatabaseApp.main((String[])args);
    }
}

