/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal.orient;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.blobstore.restore.internal.orient.NpmRestoreBlobData;
import com.sonatype.nexus.blobstore.restore.internal.orient.NpmRestoreBlobDataFactory;
import com.sonatype.nexus.repository.npm.NpmCoordinateUtil;
import com.sonatype.nexus.repository.npm.orient.NpmFacet;
import com.sonatype.nexus.repository.npm.repair.orient.NpmRepairPackageRootComponent;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.RestoreBlobDataSupport;
import org.sonatype.nexus.blobstore.restore.orient.OrientBaseRestoreBlobStrategy;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;

@Named(value="npm")
@Singleton
@Priority(value=0x7FFFFFFF)
public class OrientNpmRestoreBlobStrategy
extends OrientBaseRestoreBlobStrategy<NpmRestoreBlobData> {
    private final NpmRepairPackageRootComponent npmRepairPackageRootComponent;

    @Inject
    public OrientNpmRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix, NpmRepairPackageRootComponent npmRepairPackageRootComponent) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.npmRepairPackageRootComponent = (NpmRepairPackageRootComponent)Preconditions.checkNotNull((Object)npmRepairPackageRootComponent);
    }

    protected NpmRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return NpmRestoreBlobDataFactory.create(blobData);
    }

    protected boolean canAttemptRestore(@Nonnull NpmRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        Optional npmFacet = repository.optionalFacet(NpmFacet.class);
        if (!npmFacet.isPresent()) {
            this.log.warn("Skipping as NPM Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(@Nonnull NpmRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    @TransactionalTouchBlob
    protected boolean assetExists(@Nonnull NpmRestoreBlobData data) {
        Asset asset;
        NpmFacet facet = (NpmFacet)data.getBlobData().getRepository().facet(NpmFacet.class);
        switch (data.getType()) {
            case REPOSITORY_ROOT: {
                asset = facet.findRepositoryRootAsset();
                break;
            }
            case TARBALL: {
                asset = facet.findTarballAsset(data.getPackageId(), data.getTarballName());
                break;
            }
            case PACKAGE_ROOT: {
                asset = facet.findPackageRootAsset(data.getPackageId());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case encountered");
            }
        }
        return asset != null;
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(@Nonnull AssetBlob assetBlob, @Nonnull NpmRestoreBlobData data) throws IOException {
        NpmFacet facet = (NpmFacet)data.getBlobData().getRepository().facet(NpmFacet.class);
        switch (data.getType()) {
            case REPOSITORY_ROOT: {
                facet.putRepositoryRoot(assetBlob, null);
                break;
            }
            case TARBALL: {
                facet.putTarball(data.getPackageId(), data.getTarballName(), assetBlob, null);
                break;
            }
            case PACKAGE_ROOT: {
                facet.putPackageRoot(data.getPackageId(), assetBlob, null);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected case encountered");
            }
        }
    }

    protected boolean componentRequired(NpmRestoreBlobData data) throws IOException {
        return data.getType() == NpmRestoreBlobData.NpmType.TARBALL;
    }

    protected Query getComponentQuery(NpmRestoreBlobData data) {
        String version = NpmCoordinateUtil.extractVersion((String)data.getTarballName());
        String scope = NpmCoordinateUtil.getPackageIdScope((String)data.getPackageId());
        Query.Builder builder = Query.builder().where("name").eq((Object)NpmCoordinateUtil.getPackageIdName((String)data.getPackageId())).and("group");
        builder = scope != null ? builder.eq((Object)scope) : builder.isNull();
        return builder.and("version").eq((Object)version).build();
    }

    protected boolean shouldDeleteAsset(NpmRestoreBlobData restoreData, RestoreBlobData blobData, String path) throws IOException {
        NpmRestoreBlobData.NpmType type = restoreData.getType();
        return type == NpmRestoreBlobData.NpmType.REPOSITORY_ROOT || type == NpmRestoreBlobData.NpmType.PACKAGE_ROOT || super.shouldDeleteAsset((RestoreBlobDataSupport)restoreData, blobData, path);
    }

    protected Repository getRepository(@Nonnull NpmRestoreBlobData data) {
        return data.getBlobData().getRepository();
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.npmRepairPackageRootComponent.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of npm package metadata");
        }
    }
}

