/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.upgrade;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.upgrade.Dependencies;
import org.sonatype.nexus.common.upgrade.DependsOn;
import org.sonatype.nexus.common.upgrade.Upgrades;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.DatabaseUpgradeSupport;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;

@Named
@Singleton
@Upgrades(model="pypi", from="1.0", to="1.1")
@Dependencies(value={@DependsOn(model="component", version="1.14", checkpoint=true), @DependsOn(model="config", version="1.8")})
public class PypiUpgrade_1_1
extends DatabaseUpgradeSupport {
    private static final String SELECT_PYPI_REPOSITORIES = "select from repository where recipe_name in ['pypi-hosted', 'pypi-proxy', 'pypi-group']";
    private static final String DELETE_INDEXES = "delete from asset where bucket=? and (attributes.pypi.asset_kind='ROOT_INDEX' or attributes.pypi.asset_kind='INDEX')";
    private static final String DELETE_BROWSE_NODES = "delete from browse_node where repository_name = ?";
    private static final String P_REPOSITORY_NAME = "repository_name";
    private static final String BROWSE_NODE_CLASS = new OClassNameBuilder().type("browse_node").build();
    private static final String I_REPOSITORY_NAME = new OIndexNameBuilder().type("bucket").property("repository_name").build();
    private final Provider<DatabaseInstance> configDatabaseInstance;
    private final Provider<DatabaseInstance> componentDatabaseInstance;

    @Inject
    public PypiUpgrade_1_1(@Named(value="config") Provider<DatabaseInstance> configDatabaseInstance, @Named(value="component") Provider<DatabaseInstance> componentDatabaseInstance) {
        this.configDatabaseInstance = (Provider)Preconditions.checkNotNull(configDatabaseInstance);
        this.componentDatabaseInstance = (Provider)Preconditions.checkNotNull(componentDatabaseInstance);
    }

    public void apply() throws Exception {
        if (PypiUpgrade_1_1.hasSchemaClass(this.configDatabaseInstance, (String)"repository") && PypiUpgrade_1_1.hasSchemaClass(this.componentDatabaseInstance, (String)"asset")) {
            this.deleteIndexes();
        }
    }

    private void deleteIndexes() {
        List<String> pypiRepositoryNames;
        Throwable throwable = null;
        Object var3_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.configDatabaseInstance.get()).connect();){
            pypiRepositoryNames = db.query((OQuery)new OSQLSynchQuery(SELECT_PYPI_REPOSITORIES), new Object[0]).stream().map(d -> (String)d.field(P_REPOSITORY_NAME)).collect(Collectors.toList());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (!pypiRepositoryNames.isEmpty()) {
            OCommandSQL deleteIndexCommand = new OCommandSQL(DELETE_INDEXES);
            OCommandSQL deleteBrowseNodesCommand = new OCommandSQL(DELETE_BROWSE_NODES);
            Throwable throwable3 = null;
            Object var5_8 = null;
            try (ODatabaseDocumentTx db = ((DatabaseInstance)this.componentDatabaseInstance.get()).connect();){
                OIndex bucketIdx = db.getMetadata().getIndexManager().getIndex(I_REPOSITORY_NAME);
                pypiRepositoryNames.forEach(repositoryName -> {
                    this.log.info("Scanning pypi repository {} for index file assets", repositoryName);
                    OIdentifiable bucket = (OIdentifiable)bucketIdx.get(repositoryName);
                    if (bucket == null) {
                        this.log.warn("Unable to find bucket for {}", repositoryName);
                    } else {
                        int deletes = (Integer)db.command((OCommandRequest)deleteIndexCommand).execute(new Object[]{bucket.getIdentity()});
                        if (deletes > 0) {
                            this.log.info("Deleted {} pypi index asset(s) in repository {}: ", (Object)deletes, repositoryName);
                        }
                        if (db.getMetadata().getSchema().existsClass(BROWSE_NODE_CLASS) && (deletes = ((Integer)db.command((OCommandRequest)deleteBrowseNodesCommand).execute(new Object[]{repositoryName})).intValue()) > 0) {
                            this.log.info("Deleted {} browse node(s) in repository {}", (Object)deletes, repositoryName);
                        }
                    }
                });
            }
            catch (Throwable throwable4) {
                if (throwable3 == null) {
                    throwable3 = throwable4;
                } else if (throwable3 != throwable4) {
                    throwable3.addSuppressed(throwable4);
                }
                throw throwable3;
            }
        }
    }
}

