/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.sonatype.nexus.repository.pypi.PyPiFormat;
import com.sonatype.nexus.repository.pypi.upgrade.PyPiUpgrade_1_2;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.types.ProxyType;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.CancelableHelper;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class OrientPyPiDeleteLegacyProxyAssetsTask
extends TaskSupport
implements Cancelable {
    private final Path markerFile;
    private final RepositoryManager repositoryManager;
    private final Pattern packagePattern = Pattern.compile("packages\\/(?<name>[^/]+)\\/(?<version>[^/]+)\\/\\k<name>-\\k<version>\\.[^/]+");

    @Inject
    public OrientPyPiDeleteLegacyProxyAssetsTask(ApplicationDirectories directories, RepositoryManager repositoryManager) {
        this.markerFile = new File(directories.getWorkDirectory("db"), PyPiUpgrade_1_2.MARKER_FILE).toPath();
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    protected Object execute() throws Exception {
        Streams.stream((Iterable)this.repositoryManager.browse()).peek(r -> this.log.debug("Looking at repository: {}", r)).filter(r -> r.getFormat() instanceof PyPiFormat).peek(r -> this.log.debug("Looking at PyPI repository: {}", r)).filter(r -> r.getType() instanceof ProxyType).peek(r -> this.log.debug("Found PyPI proxy repository: {}", r)).forEach(this::deleteLegacyAssets);
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            Files.delete(this.markerFile);
        }
        return null;
    }

    private void deleteLegacyAssets(Repository repository) {
        this.log.info("Deleting legacy assets in PyPI proxy repository: {}", (Object)repository);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (StorageTx tx = (StorageTx)storageFacet.txSupplier().get();){
            tx.begin();
            Bucket bucket = tx.findBucket(repository);
            Streams.stream((Iterable)tx.browseAssets(bucket)).peek(a -> this.log.debug("Evaluating asset: {}", (Object)a.name())).filter(this::isInvalidPath).forEach(a -> {
                CancelableHelper.checkCancellation();
                this.log.info("Deleting asset: {}", (Object)a.name());
                tx.deleteAsset(a);
            });
            tx.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getMessage() {
        return "Delete legacy PyPI proxy package assets whose names start with 'packages/'";
    }

    private boolean isInvalidPath(Asset asset) {
        if ("simple/".equals(asset.name())) {
            return false;
        }
        return !this.packagePattern.matcher(asset.name()).matches();
    }
}

