/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.repair;

import com.sonatype.nexus.repository.pypi.AssetKind;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.repair.RepairMetadataComponent;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetEntityAdapter;
import org.sonatype.nexus.repository.storage.StorageTx;

@Named
@Singleton
public class OrientPyPiRepairIndexComponent
extends RepairMetadataComponent {
    @Inject
    public OrientPyPiRepairIndexComponent(RepositoryManager repositoryManager, AssetEntityAdapter assetEntityAdapter, @Named(value="hosted") Type type, @Named(value="pypi") Format format) {
        super(repositoryManager, assetEntityAdapter, type, format);
    }

    public void updateAsset(Repository repository, StorageTx tx, Asset asset) {
        String assetKind = Objects.toString(asset.formatAttributes().get("asset_kind"));
        if (AssetKind.ROOT_INDEX.name().equals(assetKind) || AssetKind.INDEX.name().equals(assetKind)) {
            tx.deleteAsset(asset);
        }
    }
}

