/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiSearchResult;
import com.sonatype.nexus.repository.pypi.internal.PyPiSearchUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.internal.SignablePyPiPackage;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiHostedFacet;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.search.SearchRequest;
import org.sonatype.nexus.repository.search.SearchService;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Handler;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.matchers.token.TokenMatcher;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;

@Named
@Singleton
public final class OrientPyPiHostedHandlers
extends ComponentSupport {
    private final SearchService searchService;
    final Handler getRootIndex = context -> {
        Content content = ((OrientPyPiHostedFacet)context.getRepository().facet(OrientPyPiHostedFacet.class)).getRootIndex();
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler getIndex = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Content content = ((OrientPyPiHostedFacet)context.getRepository().facet(OrientPyPiHostedFacet.class)).getIndex(PyPiPathUtils.name(state));
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    final Handler getPackage = context -> {
        TokenMatcher.State state = (TokenMatcher.State)context.getAttributes().require(TokenMatcher.State.class);
        Content content = ((OrientPyPiHostedFacet)context.getRepository().facet(OrientPyPiHostedFacet.class)).getPackage(PyPiPathUtils.path(state));
        if (content != null) {
            return HttpResponses.ok((Payload)content);
        }
        return HttpResponses.notFound();
    };
    protected final Handler postContent = context -> {
        SignablePyPiPackage pyPiPackage = this.extractPayloads(context);
        String action = pyPiPackage.getAttributes().get(":action");
        if (!"file_upload".equals(action)) {
            throw new IllegalStateException("Unsupported :action, found: " + action);
        }
        ((OrientPyPiHostedFacet)context.getRepository().facet(OrientPyPiHostedFacet.class)).upload(pyPiPackage);
        return HttpResponses.ok();
    };

    @Inject
    public OrientPyPiHostedHandlers(SearchService searchService) {
        this.searchService = (SearchService)Preconditions.checkNotNull((Object)searchService);
    }

    private SignablePyPiPackage extractPayloads(Context context) throws IOException {
        Preconditions.checkNotNull((Object)context);
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        Request request = context.getRequest();
        TempBlobPartPayload contentBlob = null;
        TempBlobPartPayload signatureBlob = null;
        for (PartPayload payload : (Iterable)Preconditions.checkNotNull((Object)request.getMultiparts())) {
            if (payload.isFormField()) {
                PyPiStorageUtils.addAttribute(attributes, payload);
                continue;
            }
            if ("content".equals(payload.getFieldName())) {
                Preconditions.checkState((contentBlob == null ? 1 : 0) != 0);
                contentBlob = this.createBlobFromPayload(payload, context.getRepository());
                continue;
            }
            if (!"gpg_signature".equals(payload.getFieldName())) continue;
            Preconditions.checkState((signatureBlob == null ? 1 : 0) != 0);
            signatureBlob = this.createBlobFromPayload(payload, context.getRepository());
        }
        Preconditions.checkState((contentBlob != null ? 1 : 0) != 0);
        return new SignablePyPiPackage(contentBlob, attributes, signatureBlob);
    }

    private TempBlobPartPayload createBlobFromPayload(PartPayload payload, Repository repository) throws IOException {
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        return new TempBlobPartPayload(payload, storageFacet.createTempBlob((Payload)payload, PyPiStorageUtils.HASH_ALGORITHMS));
    }

    public Handler search() {
        return context -> {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)context.getRequest().getPayload());
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = payload.openInputStream();){
                SearchRequest.Builder query = PyPiSearchUtils.parseSearchRequest(context.getRepository().getName(), is);
                List<PyPiSearchResult> results = PyPiSearchUtils.pypiSearch(query, this.searchService);
                String response = PyPiSearchUtils.buildSearchResponse(results);
                return HttpResponses.ok((Payload)new StringPayload(response, "application/xml"));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }
}

