/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.internal.SignablePyPiPackage;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiDataUtils;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiHostedFacet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.repository.transaction.TransactionalTouchBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.transaction.Transactional;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientPyPiHostedFacetImpl
extends FacetSupport
implements OrientPyPiHostedFacet {
    private final TemplateHelper templateHelper;

    @Inject
    public OrientPyPiHostedFacetImpl(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    @Override
    @TransactionalStoreBlob
    @Nullable
    public Content getRootIndex() {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientPyPiDataUtils.findAsset(tx, bucket = tx.findBucket(this.getRepository()), "simple/");
        if (asset == null) {
            try {
                return this.createAndSaveRootIndex(bucket);
            }
            catch (IOException e) {
                this.log.error("Unable to create root index for repository: {}", (Object)this.getRepository().getName(), (Object)e);
                return null;
            }
        }
        return OrientPyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
    }

    private Content createAndSaveRootIndex(Bucket bucket) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        List<PyPiLink> links = this.findAllLinks();
        Asset asset = this.createRootIndexAsset(bucket);
        String rootIndexHtml = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
        return this.storeHtmlPage(tx, asset, rootIndexHtml);
    }

    @TransactionalStoreMetadata
    protected Asset createRootIndexAsset(Bucket bucket) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.createAsset(bucket, this.getRepository().getFormat());
        asset.name("simple/");
        asset.formatAttributes().set("asset_kind", (Object)AssetKind.ROOT_INDEX.name());
        return asset;
    }

    @Transactional
    protected List<PyPiLink> findAllLinks() {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        TreeMap links = new TreeMap();
        Iterable components = tx.browseComponents(tx.findBucket(this.getRepository()));
        components.forEach(c -> {
            PyPiLink pyPiLink = links.put(c.name(), new PyPiLink(c.name(), String.valueOf(c.name()) + "/"));
        });
        return new ArrayList<PyPiLink>(links.values());
    }

    @TransactionalStoreBlob
    protected Content storeHtmlPage(StorageTx tx, Asset asset, String indexPage) throws IOException {
        StorageFacet storageFacet = (StorageFacet)this.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)new StringPayload(indexPage, "text/html"), PyPiStorageUtils.HASH_ALGORITHMS);){
            return OrientPyPiDataUtils.saveAsset(tx, asset, tempBlob, "text/html", null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @TransactionalStoreBlob
    public Content getIndex(String name) throws IOException {
        Preconditions.checkNotNull((Object)name);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        if (!OrientPyPiDataUtils.findComponentExists(tx, this.getRepository(), name)) {
            return null;
        }
        String indexPath = PyPiPathUtils.indexPath(name);
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset savedIndex = OrientPyPiDataUtils.findAsset(tx, bucket, indexPath);
        if (savedIndex == null) {
            savedIndex = this.createIndexAsset(name, tx, indexPath, bucket);
        }
        return OrientPyPiDataUtils.toContent(savedIndex, tx.requireBlob(savedIndex.requireBlobRef()));
    }

    private Asset createIndexAsset(String name, StorageTx tx, String indexPath, Bucket bucket) throws IOException {
        String html = this.buildIndex(name, tx);
        Asset savedIndex = tx.createAsset(bucket, this.getRepository().getFormat());
        savedIndex.name(indexPath);
        savedIndex.formatAttributes().set("asset_kind", (Object)AssetKind.INDEX.name());
        StorageFacet storageFacet = (StorageFacet)this.getRepository().facet(StorageFacet.class);
        Throwable throwable = null;
        Object var9_10 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((InputStream)new ByteArrayInputStream(html.getBytes(StandardCharsets.UTF_8)), PyPiStorageUtils.HASH_ALGORITHMS);){
            OrientPyPiDataUtils.saveAsset(tx, savedIndex, tempBlob, "text/html", new AttributesMap());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return savedIndex;
    }

    private String buildIndex(String name, StorageTx tx) {
        ArrayList<PyPiLink> links = new ArrayList<PyPiLink>();
        for (Asset asset : OrientPyPiDataUtils.findAssetsByComponentName(tx, this.getRepository(), name)) {
            NestedAttributesMap pypiAttributes = asset.attributes().child("pypi");
            String path = asset.name();
            String file = path.substring(path.lastIndexOf(47) + 1);
            String link = String.format("../../%s#md5=%s", path, asset.getChecksum(HashAlgorithm.MD5));
            String dataRequiresPython = (String)pypiAttributes.get("requires_python", String.class, (Object)"");
            links.add(new PyPiLink(file, link, dataRequiresPython));
        }
        return PyPiIndexUtils.buildIndexPage(this.templateHelper, name, links);
    }

    @Override
    @TransactionalTouchBlob
    public Content getPackage(String packagePath) {
        Preconditions.checkNotNull((Object)packagePath);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = OrientPyPiDataUtils.findAsset(tx, tx.findBucket(this.getRepository()), packagePath);
        if (asset == null) {
            return null;
        }
        Content content = OrientPyPiDataUtils.toContent(asset, tx.requireBlob(asset.requireBlobRef()));
        PyPiStorageUtils.mayAddEtag(content.getAttributes(), String.valueOf(asset.getChecksum(HashAlgorithm.SHA1)));
        return content;
    }

    @Override
    @TransactionalStoreBlob
    public Asset upload(String filename, Map<String, String> attributes, TempBlobPartPayload payload) throws IOException {
        return this.savePyPiWheelPayload(filename, attributes, payload);
    }

    @Override
    @TransactionalStoreBlob
    public Content upload(String filename, Map<String, String> attributes, AssetBlob assetBlob) {
        Preconditions.checkNotNull((Object)filename);
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)assetBlob);
        Asset asset = this.savePyPiWheelMetadata(attributes, filename);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return OrientPyPiDataUtils.saveAsset(tx, asset, assetBlob);
    }

    @Override
    @TransactionalStoreBlob
    public Content uploadSignature(String name, String version, TempBlobPartPayload payload) {
        return this.storeGpgSignaturePayload(payload, name, version);
    }

    @Override
    @TransactionalStoreBlob
    public Content uploadSignature(String name, String version, String filename, AssetBlob assetBlob) {
        Asset asset = this.storeGpgSignatureMetadata(filename, name, version);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        return OrientPyPiDataUtils.saveAsset(tx, asset, assetBlob);
    }

    protected Asset savePyPiWheelMetadata(Map<String, String> attributes, String filename) {
        String name = (String)Preconditions.checkNotNull((Object)attributes.get("name"));
        String version = (String)Preconditions.checkNotNull((Object)attributes.get("version"));
        String normalizedName = PyPiPathUtils.normalizeName(name);
        PyPiIndexFacet indexFacet = (PyPiIndexFacet)this.facet(PyPiIndexFacet.class);
        indexFacet.deleteIndex(name);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        String packagePath = this.createPackagePath(name, version, filename);
        Component component = this.findOrCreateComponent(name, version, normalizedName, indexFacet, tx, bucket);
        component.formatAttributes().set("summary", (Object)attributes.get("summary"));
        tx.saveComponent(component);
        Asset asset = this.findOrCreateAsset(tx, bucket, packagePath, component, AssetKind.PACKAGE.name());
        OrientPyPiDataUtils.copyAttributes(asset, attributes);
        return asset;
    }

    protected Asset savePyPiWheelPayload(String filename, Map<String, String> attributes, TempBlobPartPayload wheelPayload) throws IOException {
        Preconditions.checkNotNull((Object)filename);
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)wheelPayload);
        TempBlob tempBlob = wheelPayload.getTempBlob();
        PyPiStorageUtils.validateMd5Hash(attributes, tempBlob);
        Asset asset = this.savePyPiWheelMetadata(attributes, filename);
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        OrientPyPiDataUtils.saveAsset(tx, asset, tempBlob, (Payload)wheelPayload);
        return asset;
    }

    private Component findOrCreateComponent(String name, String version, String normalizedName, PyPiIndexFacet indexFacet, StorageTx tx, Bucket bucket) {
        Component component = OrientPyPiDataUtils.findComponent(tx, this.getRepository(), normalizedName, version);
        if (component == null) {
            component = this.createComponent(name, version, normalizedName, tx, bucket);
            indexFacet.deleteRootIndex();
        }
        return component;
    }

    private Component createComponent(String name, String version, String normalizedName, StorageTx tx, Bucket bucket) {
        Component component = ((Component)tx.createComponent(bucket, this.getRepository().getFormat()).name(normalizedName)).version(version);
        PyPiStorageUtils.getNameAttributes(name).forEach((k, v) -> {
            Object object = component.formatAttributes().set(k, v);
        });
        component.formatAttributes().set("version", (Object)version);
        return component;
    }

    private Asset findOrCreateAsset(StorageTx tx, Bucket bucket, String packagePath, Component component, String assetKind) {
        Asset asset = OrientPyPiDataUtils.findAsset(tx, bucket, packagePath);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(packagePath);
            asset.formatAttributes().set("asset_kind", (Object)assetKind);
        }
        return asset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Asset upload(SignablePyPiPackage pyPiPackage) throws IOException {
        Map<String, String> attributes = pyPiPackage.getAttributes();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                Asset savedPiPyPackage;
                TempBlobPartPayload wheelPayload = pyPiPackage.getWheelPayload();
                try {
                    try (TempBlobPartPayload gpgPayload = pyPiPackage.getGpgSignature();){
                        savedPiPyPackage = this.storeWheelAndSignaturePayloads(wheelPayload, gpgPayload, attributes);
                    }
                    if (wheelPayload == null) return savedPiPyPackage;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (wheelPayload == null) throw throwable;
                    wheelPayload.close();
                    throw throwable;
                }
                wheelPayload.close();
                return savedPiPyPackage;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.info("Unable to store wheel and gpg signature", (Throwable)e);
            throw e;
        }
    }

    @TransactionalStoreBlob
    protected Asset storeWheelAndSignaturePayloads(TempBlobPartPayload wheelPayload, TempBlobPartPayload gpgPayload, Map<String, String> attributes) throws IOException {
        Asset wheelAsset = this.storeWheelPayload(wheelPayload, attributes);
        this.storeGpgSignaturePayload(gpgPayload, attributes);
        return wheelAsset;
    }

    protected Asset storeWheelPayload(TempBlobPartPayload wheelPayload, Map<String, String> attributes) throws IOException {
        String wheelFileName = wheelPayload.getName();
        return this.savePyPiWheelPayload(wheelFileName, attributes, wheelPayload);
    }

    protected Content storeGpgSignaturePayload(TempBlobPartPayload gpgPayload, Map<String, String> attributes) {
        return this.storeGpgSignaturePayload(gpgPayload, attributes.get("name"), attributes.get("version"));
    }

    protected Content storeGpgSignaturePayload(TempBlobPartPayload gpgPayload, String name, String version) {
        if (gpgPayload != null) {
            Asset asset = this.storeGpgSignatureMetadata(gpgPayload.getName(), name, version);
            return this.saveGpgSignatureAsset((StorageTx)UnitOfWork.currentTx(), asset, gpgPayload);
        }
        return null;
    }

    protected Asset storeGpgSignatureMetadata(String filename, String name, String version) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = this.findOrCreateComponent(name, version, PyPiPathUtils.normalizeName(name), (PyPiIndexFacet)this.facet(PyPiIndexFacet.class), tx, tx.findBucket(this.getRepository()));
        if (component.isNew()) {
            tx.saveComponent(component);
        }
        return this.createGpgSignatureAsset(filename, name, version, component, tx);
    }

    private Asset createGpgSignatureAsset(String signatureFileName, String name, String version, Component component, StorageTx tx) {
        String packageSignaturePath = this.createPackagePath(name, version, signatureFileName);
        Bucket bucket = tx.findBucket(this.getRepository());
        return this.findOrCreateAsset(tx, bucket, packageSignaturePath, component, AssetKind.PACKAGE_SIGNATURE.name());
    }

    private Content saveGpgSignatureAsset(StorageTx tx, Asset asset, TempBlobPartPayload gpgSignaturePayload) {
        try {
            return OrientPyPiDataUtils.saveAsset(tx, asset, gpgSignaturePayload.getTempBlob(), (Payload)gpgSignaturePayload);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public String createPackagePath(String name, String version, String filename) {
        String normalizedName = PyPiPathUtils.normalizeName(name);
        return PyPiPathUtils.packagesPath(normalizedName, version, filename);
    }

    @Override
    public Map<String, String> extractMetadata(InputStream inputStream) {
        return PyPiInfoUtils.extractMetadata(inputStream);
    }
}

