/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sonatype.nexus.repository.pypi.PyPiAttributes;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;

public final class OrientPyPiDataUtils {
    static Content toContent(Asset asset, Blob blob) {
        Content content = new Content((Payload)new BlobPayload(blob, asset.requireContentType()));
        Content.extractFromAsset((Asset)asset, PyPiStorageUtils.HASH_ALGORITHMS, (AttributesMap)content.getAttributes());
        return content;
    }

    @Nullable
    static Component findComponent(StorageTx tx, Repository repository, String name, String version) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)name).and("version").eq((Object)version).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    static boolean findComponentExists(StorageTx tx, Repository repository, String name) {
        return tx.countComponents(Query.builder().where("name").eq((Object)name).build(), Collections.singletonList(repository)) > 0L;
    }

    static Iterable<Asset> findAssetsByComponentName(StorageTx tx, Repository repository, String name) {
        return tx.findAssets(Query.builder().where("component.name").eq((Object)name).suffix("order by name desc").build(), Collections.singletonList(repository));
    }

    @Nullable
    static Asset findAsset(StorageTx tx, Bucket bucket, String assetName) {
        return tx.findAssetWithProperty("name", (Object)assetName, bucket);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, Payload payload) throws IOException {
        AttributesMap contentAttributes = null;
        String contentType = null;
        if (payload instanceof Content) {
            contentAttributes = ((Content)payload).getAttributes();
            contentType = payload.getContentType();
        }
        return OrientPyPiDataUtils.saveAsset(tx, asset, tempBlob, contentType, contentAttributes);
    }

    static Content saveAsset(StorageTx tx, Asset asset, TempBlob tempBlob, @Nullable String contentType, @Nullable AttributesMap contentAttributes) throws IOException {
        Content.applyToAsset((Asset)asset, (AttributesMap)Content.maintainLastModified((Asset)asset, (AttributesMap)contentAttributes));
        AssetBlob assetBlob = tx.setBlob(asset, asset.name(), tempBlob, null, contentType, false);
        tx.saveAsset(asset);
        return OrientPyPiDataUtils.toContent(asset, assetBlob.getBlob());
    }

    static Content saveAsset(StorageTx tx, Asset asset, AssetBlob assetBlob) {
        tx.attachBlob(asset, assetBlob);
        tx.saveAsset(asset);
        return OrientPyPiDataUtils.toContent(asset, assetBlob.getBlob());
    }

    static void copyAttributes(Asset asset, Map<String, String> attributes) {
        Preconditions.checkNotNull((Object)asset);
        Preconditions.checkNotNull(attributes);
        for (String attribute : PyPiAttributes.SUPPORTED_ATTRIBUTES) {
            String value = Strings.nullToEmpty((String)attributes.get(attribute)).trim();
            if (value.isEmpty()) continue;
            asset.formatAttributes().set(attribute, (Object)value);
        }
    }

    private OrientPyPiDataUtils() {
    }
}

