/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient.internal;

import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
public class OrientPyPiComponentMaintenance
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = tx.findAsset(assetId, bucket = tx.findBucket(this.getRepository()));
        if (asset == null) {
            return Collections.emptySet();
        }
        HashSet<String> deletedAssets = new HashSet<String>();
        deletedAssets.addAll(super.deleteAssetTx(assetId, deleteBlob));
        EntityId componentId = asset.componentId();
        if (componentId != null) {
            this.deleteRootIndex();
            this.deleteCachedIndexForPackage(asset);
            Component component = tx.findComponentInBucket(componentId, bucket);
            if (component != null && !tx.browseAssets(component).iterator().hasNext()) {
                deletedAssets.addAll(this.deleteComponentTx(componentId, deleteBlob).getAssets());
            }
        }
        return deletedAssets;
    }

    private void deleteCachedIndexForPackage(Asset asset) {
        if (this.assetKindIsPackage(asset)) {
            this.deleteCachedIndex((String)asset.formatAttributes().get("name", String.class));
        }
    }

    private boolean assetKindIsPackage(Asset asset) {
        return AssetKind.PACKAGE.name().equals(asset.formatAttributes().get("asset_kind"));
    }

    @TransactionalDeleteBlob
    protected DefaultComponentMaintenanceImpl.DeletionResult deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, tx.findBucket(this.getRepository()));
        if (component == null) {
            return new DefaultComponentMaintenanceImpl.DeletionResult(null, Collections.emptySet());
        }
        this.deleteRootIndex();
        this.deleteCachedIndex(component.name());
        this.log.debug("Deleting component: {}", (Object)component.toStringExternal());
        return new DefaultComponentMaintenanceImpl.DeletionResult(component, tx.deleteComponent(component, deleteBlobs));
    }

    private void deleteRootIndex() {
        PyPiIndexFacet facet = (PyPiIndexFacet)this.getRepository().facet(PyPiIndexFacet.class);
        facet.deleteRootIndex();
    }

    private void deleteCachedIndex(String assetName) {
        PyPiIndexFacet facet = (PyPiIndexFacet)this.getRepository().facet(PyPiIndexFacet.class);
        facet.deleteIndex(assetName);
    }
}

