/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.orient;

import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.orient.internal.OrientPyPiHostedFacet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.util.CollectionUtils;
import org.sonatype.nexus.common.text.Strings2;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.importtask.ImportFileConfiguration;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.PartPayload;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;
import org.sonatype.nexus.rest.ValidationErrorsException;

@Named(value="pypi")
@Singleton
public class OrientPyPiUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public OrientPyPiUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public Content handle(Repository repository, File content, String path) throws IOException {
        return this.handle(new ImportFileConfiguration(repository, content, path));
    }

    public Content handle(ImportFileConfiguration configuration) throws IOException {
        StorageFacet storage = (StorageFacet)configuration.getRepository().facet(StorageFacet.class);
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = storage.createTempBlob(configuration.getFile().toPath(), PyPiStorageUtils.HASH_ALGORITHMS, configuration.isHardLinkingEnabled());){
            if (configuration.getFile().getName().endsWith(".asc")) {
                return this.importSignatureFile(configuration, blob);
            }
            return this.importPackageFile(configuration, blob);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content importPackageFile(ImportFileConfiguration configuration, TempBlob blob) throws IOException {
        Repository repository = configuration.getRepository();
        File packageFile = configuration.getFile();
        OrientPyPiHostedFacet facet = (OrientPyPiHostedFacet)repository.facet(OrientPyPiHostedFacet.class);
        Map<String, String> metadata = this.getAndValidateMetadata(facet, blob);
        String name = this.getAndValidateName(metadata);
        String version = this.getAndValidateVersion(metadata);
        String filename = packageFile.getName();
        String packagePath = facet.createPackagePath(name, version, filename);
        String contentType = Files.probeContentType(packageFile.toPath());
        facet.upload(filename, metadata, new TempBlobPartPayload("", false, name, contentType, blob));
        return facet.getPackage(packagePath);
    }

    private Content importSignatureFile(ImportFileConfiguration configuration, TempBlob blob) {
        Repository repository = configuration.getRepository();
        File signatureFile = configuration.getFile();
        String assetName = configuration.getAssetName();
        String name = PyPiFileUtils.extractNameFromPath(assetName);
        String version = PyPiFileUtils.extractVersionFromPath(assetName);
        OrientPyPiHostedFacet facet = (OrientPyPiHostedFacet)repository.facet(OrientPyPiHostedFacet.class);
        return facet.uploadSignature(name, version, new TempBlobPartPayload("", false, signatureFile.getName(), "text/plain", blob));
    }

    private Map<String, String> getAndValidateMetadata(OrientPyPiHostedFacet facet, TempBlob blob) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream in = blob.get();){
            return this.getAndValidateMetadata(facet, in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> getAndValidateMetadata(OrientPyPiHostedFacet facet, InputStream in) {
        Map<String, String> metadata = facet.extractMetadata(in);
        if (CollectionUtils.isEmpty(metadata)) {
            throw new ValidationErrorsException("Unable to extract PyPI metadata from provided archive.");
        }
        return metadata;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        OrientPyPiHostedFacet facet = (OrientPyPiHostedFacet)repository.facet(OrientPyPiHostedFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        PartPayload payload = ((AssetUpload)upload.getAssetUploads().get(0)).getPayload();
        Throwable throwable = null;
        Object var7_8 = null;
        try (TempBlob tempBlob = storageFacet.createTempBlob((Payload)payload, PyPiStorageUtils.HASH_ALGORITHMS);){
            Map<String, String> metadata = this.getAndValidateMetadata(facet, tempBlob);
            String name = this.getAndValidateName(metadata);
            String version = this.getAndValidateVersion(metadata);
            String filename = StringUtils.isNotBlank((CharSequence)payload.getName()) ? payload.getName() : String.valueOf(name) + '-' + version + '.' + metadata.get("archive_type");
            String path = facet.createPackagePath(name, version, filename);
            this.ensurePermitted(repository.getName(), "pypi", path, this.coordinatesFromMetadata(metadata));
            return (UploadResponse)TransactionalStoreBlob.operation.withDb(storageFacet.txSupplier()).throwing(IOException.class).call(() -> new UploadResponse(facet.upload(filename, metadata, new TempBlobPartPayload(payload, tempBlob))));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getAndValidateName(Map<String, String> metadata) {
        String name = metadata.get("name");
        if (Strings2.isBlank((String)name)) {
            throw new ValidationErrorsException("Metadata is missing the name attribute");
        }
        return name;
    }

    private String getAndValidateVersion(Map<String, String> metadata) {
        String version = metadata.get("version");
        if (Strings2.isBlank((String)version)) {
            throw new ValidationErrorsException("Metadata is missing the version attribute");
        }
        return version;
    }

    private Map<String, String> coordinatesFromMetadata(Map<String, String> packageMetadata) {
        return ImmutableMap.of((Object)"name", (Object)packageMetadata.get("name"), (Object)"version", (Object)packageMetadata.get("version"));
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("pypi", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }

    public boolean supportsExportImport() {
        return true;
    }
}

