/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal.orient;

import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.OrientReplicationFacetSupport;
import org.sonatype.nexus.repository.storage.OrientReplicationIngestionService;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Named
public class OrientPyPiReplicationFacet
extends OrientReplicationFacetSupport {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final TokenParser packageParser = new TokenParser("packages/{name}/{version}/{filename}");
    private final OrientReplicationIngestionService ingestionService;

    @Inject
    public OrientPyPiReplicationFacet(OrientReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, AssetBlob assetBlob, NestedAttributesMap assetAttributes, NestedAttributesMap componentAttributes) {
        Map packagePath = packageParser.parse(path);
        if (packagePath != null) {
            String name = (String)packagePath.get(NAME);
            String version = (String)packagePath.get(VERSION);
            Component component = this.ingestionService.replicateComponent(this.getRepository(), name, version, null, componentAttributes);
            this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob, component);
        } else if (PyPiPathUtils.isIndexPath(path)) {
            this.ingestionService.replicateAsset(this.getRepository(), path, assetAttributes, assetBlob);
        }
    }

    public boolean doReplicateDelete(String path) {
        return this.ingestionService.replicateDeleteAsset(this.getRepository(), path);
    }
}

