/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal.datastore;

import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.content.facet.ContentFacet;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.content.replication.ReplicationFacetSupport;
import org.sonatype.nexus.repository.content.replication.ReplicationIngestionService;
import org.sonatype.nexus.repository.view.matchers.token.TokenParser;

@Named(value="pypi")
public class PyPiReplicationFacet
extends ReplicationFacetSupport {
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final TokenParser packageParser = new TokenParser("packages/{name}/{version}/{filename}");
    private final ReplicationIngestionService ingestionService;

    @Inject
    public PyPiReplicationFacet(ReplicationIngestionService ingestionService) {
        this.ingestionService = Objects.requireNonNull(ingestionService);
    }

    public void doReplicate(String path, Blob blob, Map<String, Object> assetAttributes, Map<String, Object> componentAttributes) {
        Map packagePath;
        ContentFacet contentFacet = (ContentFacet)this.facet(ContentFacet.class);
        FluentAssets fluentAssets = contentFacet.assets();
        FluentComponents fluentComponents = contentFacet.components();
        String normalizedPath = path;
        if (normalizedPath.startsWith("/")) {
            normalizedPath = normalizedPath.substring(1);
        }
        if ((packagePath = packageParser.parse(normalizedPath)) != null) {
            String name = (String)packagePath.get(NAME);
            String version = (String)packagePath.get(VERSION);
            FluentComponent component = this.ingestionService.replicateComponent(fluentComponents, componentAttributes, name, version);
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.PACKAGE.toString(), component);
        } else if (PyPiPathUtils.isRootIndexPath(normalizedPath)) {
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.ROOT_INDEX.toString());
        } else if (PyPiPathUtils.isIndexPath(normalizedPath)) {
            this.ingestionService.replicateAsset(fluentAssets, path, blob, assetAttributes, AssetKind.INDEX.toString());
        }
    }
}

