/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.internal.PyPiSearchResult;
import javax.xml.stream.XMLStreamWriter;

final class SearchResponseWriter
implements AutoCloseable {
    private final XMLStreamWriter writer;
    private boolean writtenEntry = false;

    public SearchResponseWriter(XMLStreamWriter writer) {
        this.writer = (XMLStreamWriter)Preconditions.checkNotNull((Object)writer);
    }

    public void writePrologue() throws Exception {
        this.writer.writeStartElement("methodResponse");
        this.writer.writeStartElement("params");
        this.writer.writeStartElement("param");
        this.writer.writeStartElement("value");
        this.writer.writeStartElement("array");
        this.writer.writeStartElement("data");
    }

    public void writeEpilogue() throws Exception {
        if (this.writtenEntry) {
            this.writer.writeEndElement();
        }
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.flush();
    }

    public void writeEntry(PyPiSearchResult result) throws Exception {
        Preconditions.checkNotNull((Object)result);
        if (!this.writtenEntry) {
            this.writer.writeStartElement("value");
            this.writtenEntry = true;
        }
        this.writer.writeStartElement("struct");
        this.writeMember("_pypi_ordering", "boolean", "0");
        this.writeMember("name", "string", result.getName());
        this.writeMember("version", "string", result.getVersion());
        this.writeMember("summary", "string", result.getSummary());
        this.writer.writeEndElement();
    }

    private void writeMember(String name, String type, String value) throws Exception {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)value);
        this.writer.writeStartElement("member");
        this.writer.writeStartElement("name");
        this.writer.writeCharacters(name);
        this.writer.writeEndElement();
        this.writer.writeStartElement("value");
        this.writer.writeStartElement(type);
        this.writer.writeCharacters(value);
        this.writer.writeEndElement();
        this.writer.writeEndElement();
        this.writer.writeEndElement();
    }

    @Override
    public void close() throws Exception {
        this.writer.close();
    }
}

