/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public final class PyPiLink {
    private final String file;
    private final String link;
    private final String dataRequiresPython;

    public PyPiLink(@Nonnull String file, @Nonnull String link, String dataRequiresPython) {
        this.file = (String)Preconditions.checkNotNull((Object)file);
        this.link = (String)Preconditions.checkNotNull((Object)link);
        this.dataRequiresPython = dataRequiresPython != null ? dataRequiresPython : "";
    }

    public PyPiLink(String file, String link) {
        this(file, link, "");
    }

    public String getLink() {
        return this.link;
    }

    public String getFile() {
        return this.file;
    }

    public String getDataRequiresPython() {
        return this.dataRequiresPython;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PyPiLink pyPiLink = (PyPiLink)o;
        return Objects.equal((Object)this.file, (Object)pyPiLink.file) && Objects.equal((Object)this.link, (Object)pyPiLink.link) && Objects.equal((Object)this.dataRequiresPython, (Object)pyPiLink.dataRequiresPython);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.file, this.link, this.dataRequiresPython});
    }
}

