/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.io.InputStreamSupplier;
import org.sonatype.nexus.mime.MimeRulesSource;
import org.sonatype.nexus.repository.mime.ContentValidator;
import org.sonatype.nexus.repository.mime.DefaultContentValidator;

@Named(value="pypi")
@Singleton
public class PyPiContentValidator
extends ComponentSupport
implements ContentValidator {
    protected static final String ASC_FILE_EXTENSION = ".asc";
    protected static final String TEXT_FILE_EXTENSION = ".txt";
    private final DefaultContentValidator defaultContentValidator;

    @Inject
    public PyPiContentValidator(DefaultContentValidator defaultContentValidator) {
        this.defaultContentValidator = (DefaultContentValidator)Preconditions.checkNotNull((Object)defaultContentValidator);
    }

    @Nonnull
    public String determineContentType(boolean strictContentTypeValidation, InputStreamSupplier contentSupplier, @Nullable MimeRulesSource mimeRulesSource, @Nullable String contentName, @Nullable String declaredContentType) throws IOException {
        String name = this.modifyContentNameForSpecialCases(contentName);
        return this.defaultContentValidator.determineContentType(strictContentTypeValidation, contentSupplier, mimeRulesSource, name, declaredContentType);
    }

    private String modifyContentNameForSpecialCases(String contentName) {
        if (this.isAscFileExtension(contentName)) {
            return String.valueOf(contentName) + TEXT_FILE_EXTENSION;
        }
        return contentName;
    }

    private boolean isAscFileExtension(@Nullable String contentName) {
        return StringUtils.endsWith((String)contentName, (String)ASC_FILE_EXTENSION);
    }
}

