/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.sonatype.nexus.repository.pypi.AssetKind;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.PyPiDataUtils;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.content.AssetBlob;
import org.sonatype.nexus.repository.content.Component;
import org.sonatype.nexus.repository.content.facet.ContentFacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentAssets;
import org.sonatype.nexus.repository.content.fluent.FluentComponent;
import org.sonatype.nexus.repository.content.fluent.FluentQuery;
import org.sonatype.nexus.repository.content.store.FormatStoreManager;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;

@Named(value="pypi")
public class PypiContentFacetImpl
extends ContentFacetSupport
implements PypiContentFacet {
    private static final Iterable<HashAlgorithm> HASHING = ImmutableList.of((Object)HashAlgorithm.MD5, (Object)HashAlgorithm.SHA1);

    @Inject
    public PypiContentFacetImpl(@Named(value="pypi") FormatStoreManager formatStoreManager) {
        super(formatStoreManager);
    }

    @Override
    public Iterable<FluentAsset> browseAssets() {
        return Continuations.iterableOf((arg_0, arg_1) -> ((FluentAssets)this.assets()).browse(arg_0, arg_1));
    }

    @Override
    public Optional<FluentAsset> getAsset(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.assets().path(path).find();
    }

    @Override
    public boolean delete(String path) {
        Preconditions.checkNotNull((Object)path);
        return this.assets().path(path).find().map(FluentAsset::delete).orElse(false);
    }

    @Override
    public FluentAsset saveAsset(String packagePath, FluentComponent component, String assetKind, TempBlob tempBlob) {
        Preconditions.checkNotNull((Object)packagePath);
        Preconditions.checkNotNull((Object)component);
        Preconditions.checkNotNull((Object)assetKind);
        Preconditions.checkNotNull((Object)tempBlob);
        return this.assets().path(packagePath).kind(assetKind).component((Component)component).blob(tempBlob).save();
    }

    @Override
    public FluentAsset saveAsset(String packagePath, String assetKind, TempBlob tempBlob) {
        Preconditions.checkNotNull((Object)packagePath);
        Preconditions.checkNotNull((Object)assetKind);
        Preconditions.checkNotNull((Object)tempBlob);
        return this.assets().path(packagePath).kind(assetKind).blob(tempBlob).save();
    }

    @Override
    public boolean isComponentExists(String name) {
        return this.componentsByName(name).count() > 0;
    }

    @Override
    public List<FluentAsset> assetsByComponentName(String name) {
        return Continuations.streamOf((arg_0, arg_1) -> this.componentsByName(name).browse(arg_0, arg_1)).flatMap(component -> component.assets().stream()).collect(Collectors.toList());
    }

    @Override
    public FluentComponent findOrCreateComponent(String name, String version, String normalizedName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)normalizedName);
        Map<String, String> attributes = PyPiStorageUtils.getNameAttributes(name);
        return this.components().name(normalizedName).version(version).attributes("pypi", attributes).getOrCreate();
    }

    @Override
    public TempBlob getTempBlob(Payload payload) {
        Preconditions.checkNotNull((Object)payload);
        return this.blobs().ingest(payload, HASHING);
    }

    @Override
    public TempBlob getTempBlob(InputStream content, @Nullable String contentType) {
        return this.blobs().ingest(content, contentType, HASHING);
    }

    @Override
    public FluentAsset putWheel(String filename, Map<String, String> attributes, TempBlob tempBlob, String name) {
        Preconditions.checkNotNull((Object)filename);
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)tempBlob);
        Preconditions.checkNotNull((Object)name);
        String version = (String)Preconditions.checkNotNull((Object)attributes.get("version"));
        String normalizedName = PyPiPathUtils.normalizeName(name);
        String packagePath = this.createPackagePath(name, version, filename);
        String summary = attributes.get("summary");
        Map<String, Object> componentFormatAttributes = PyPiDataUtils.getComponentPackageFormatAttributes(name, version, summary);
        FluentComponent component = this.components().name(normalizedName).version(version).attributes("pypi", componentFormatAttributes).getOrCreate();
        Map<String, Object> assetFormatAttributes = PyPiDataUtils.getAssetPackageFormatAttributes(attributes);
        return this.assets().path(packagePath).kind(AssetKind.PACKAGE.name()).component((Component)component).blob(tempBlob).attributes("pypi", assetFormatAttributes).save();
    }

    @Override
    public Content getPackage(String packagePath) {
        Preconditions.checkNotNull((Object)packagePath);
        FluentAsset asset = this.getAsset(packagePath).orElse(null);
        if (asset == null) {
            return null;
        }
        AssetBlob blob = asset.blob().orElse(null);
        if (blob == null) {
            return null;
        }
        Content content = asset.download();
        PyPiStorageUtils.mayAddEtag(content.getAttributes(), (String)blob.checksums().get(HashAlgorithm.SHA1.name()));
        return content;
    }

    @Override
    public Optional<Content> getIndex(String name) {
        return this.assets().path(ContentPypiPathUtils.indexPath(name)).find().map(FluentAsset::download);
    }

    @Override
    public Content putIndex(String name, Payload index) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (TempBlob blob = this.getTempBlob(index);){
            return this.assets().path(ContentPypiPathUtils.indexPath(name)).kind(AssetKind.INDEX.name()).blob(blob).save().download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putRootIndex(Payload rootIndex) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TempBlob tempBlob = this.getTempBlob(rootIndex);){
            return this.saveRootIndex(tempBlob).download();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Content putWheelSignature(String name, String version, TempBlobPartPayload gpgPayload) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)version);
        Preconditions.checkNotNull((Object)gpgPayload);
        FluentComponent component = this.components().name(name).version(version).find().orElseGet(() -> this.findOrCreateComponent(name, version, PyPiPathUtils.normalizeName(name)));
        return this.saveAsset(this.createPackagePath(name, version, gpgPayload.getName()), component, AssetKind.PACKAGE_SIGNATURE.name(), gpgPayload.getTempBlob()).markAsCached((Payload)gpgPayload).download();
    }

    private FluentQuery<FluentComponent> componentsByName(String name) {
        String filter = "name = #{filterParams.nameParam}";
        ImmutableMap params = ImmutableMap.of((Object)"nameParam", (Object)name);
        return this.components().byFilter(filter, (Map)params);
    }

    private FluentAsset saveRootIndex(TempBlob tempBlob) {
        return this.assets().path(ContentPypiPathUtils.indexPath()).kind(AssetKind.ROOT_INDEX.name()).blob(tempBlob).save();
    }

    private String createPackagePath(String name, String version, String filename) {
        String normalizedName = PyPiPathUtils.normalizeName(name);
        return ContentPypiPathUtils.packagesPath(normalizedName, version, filename);
    }
}

