/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import javax.inject.Named;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;

@Named
public class PyPiIndexFacetImpl
extends FacetSupport
implements PyPiIndexFacet {
    @Override
    public void deleteRootIndex() {
        this.content().delete(ContentPypiPathUtils.indexPath());
    }

    @Override
    public void deleteIndex(String packageName) {
        String indexPath = ContentPypiPathUtils.indexPath(PyPiPathUtils.normalizeName(packageName));
        PypiContentFacet contentFacet = this.content();
        FluentAsset cachedIndex = contentFacet.assets().path(indexPath).find().orElse(null);
        if (cachedIndex == null) {
            indexPath = ContentPypiPathUtils.indexPath(packageName);
            cachedIndex = contentFacet.assets().path(indexPath).find().orElse(null);
        }
        if (cachedIndex != null) {
            cachedIndex.delete();
        }
    }

    private PypiContentFacet content() {
        return (PypiContentFacet)this.getRepository().facet(PypiContentFacet.class);
    }
}

