/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi.datastore.internal;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.PyPiInfoUtils;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.PyPiDataUtils;
import com.sonatype.nexus.repository.pypi.datastore.PypiContentFacet;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexFacet;
import com.sonatype.nexus.repository.pypi.internal.PyPiIndexUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiLink;
import com.sonatype.nexus.repository.pypi.internal.PyPiStorageUtils;
import com.sonatype.nexus.repository.pypi.internal.SignablePyPiPackage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.entity.Continuations;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.FacetSupport;
import org.sonatype.nexus.repository.content.fluent.FluentAsset;
import org.sonatype.nexus.repository.content.fluent.FluentComponents;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;
import org.sonatype.nexus.repository.view.payloads.StringPayload;
import org.sonatype.nexus.repository.view.payloads.TempBlob;
import org.sonatype.nexus.repository.view.payloads.TempBlobPartPayload;

@Named
@Facet.Exposed
public class PyPiHostedFacet
extends FacetSupport {
    private final TemplateHelper templateHelper;

    @Inject
    public PyPiHostedFacet(TemplateHelper templateHelper) {
        Preconditions.checkNotNull((Object)templateHelper);
        this.templateHelper = templateHelper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FluentAsset upload(SignablePyPiPackage pyPiPackage) throws IOException {
        Map<String, String> attributes = pyPiPackage.getAttributes();
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                FluentAsset savedPiPyPackage;
                TempBlobPartPayload wheelPayload = pyPiPackage.getWheelPayload();
                try {
                    try (TempBlobPartPayload gpgPayload = pyPiPackage.getGpgSignature();){
                        savedPiPyPackage = this.storeWheelAndSignaturePayloads(wheelPayload, gpgPayload, attributes);
                    }
                    if (wheelPayload == null) return savedPiPyPackage;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (wheelPayload == null) throw throwable;
                    wheelPayload.close();
                    throw throwable;
                }
                wheelPayload.close();
                return savedPiPyPackage;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.info("Unable to store wheel and gpg signature", (Throwable)e);
            throw e;
        }
    }

    public Content upload(String filename, Map<String, String> attributes, TempBlobPartPayload payload) {
        return this.savePyPiWheelPayload(filename, attributes, payload).download();
    }

    public Content uploadSignature(String name, String version, TempBlobPartPayload payload) {
        return this.storeGpgSignaturePayload(payload, name, version);
    }

    public String createPackagePath(String name, String version, String filename) {
        String normalizedName = PyPiPathUtils.normalizeName(name);
        return ContentPypiPathUtils.packagesPath(normalizedName, version, filename);
    }

    public Content getPackage(String packagePath) {
        Preconditions.checkNotNull((Object)packagePath);
        return this.contentFacet().getPackage(packagePath);
    }

    public Content getRootIndex() {
        PypiContentFacet contentFacet = this.contentFacet();
        return contentFacet.getAsset(ContentPypiPathUtils.indexPath()).map(FluentAsset::download).orElseGet(() -> contentFacet.putRootIndex(this.createRootIndex()));
    }

    public Content getIndex(String name) {
        Preconditions.checkNotNull((Object)name);
        PypiContentFacet contentFacet = this.contentFacet();
        if (!contentFacet.isComponentExists(name)) {
            return null;
        }
        return contentFacet.getIndex(name).orElseGet(() -> contentFacet.putIndex(name, this.createIndex(name)));
    }

    public Map<String, String> extractMetadata(TempBlob tempBlob) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = tempBlob.get();){
            return PyPiInfoUtils.extractMetadata(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private PypiContentFacet contentFacet() {
        return (PypiContentFacet)this.facet(PypiContentFacet.class);
    }

    private Payload createRootIndex() {
        Collection<PyPiLink> links = this.findAllLinks();
        String rootIndexHtml = PyPiIndexUtils.buildRootIndexPage(this.templateHelper, links);
        return new StringPayload(rootIndexHtml, "text/html");
    }

    private Collection<PyPiLink> findAllLinks() {
        TreeMap links = new TreeMap();
        FluentComponents components = this.contentFacet().components();
        Continuations.iterableOf((arg_0, arg_1) -> ((FluentComponents)components).browse(arg_0, arg_1)).forEach(c -> {
            PyPiLink pyPiLink = links.put(c.name(), new PyPiLink(c.name(), String.valueOf(c.name()) + "/"));
        });
        return links.values();
    }

    private Payload createIndex(String name) {
        String html = this.buildIndex(name);
        return new BytesPayload(html.getBytes(StandardCharsets.UTF_8), "text/html");
    }

    private String buildIndex(String name) {
        List<FluentAsset> assets = this.contentFacet().assetsByComponentName(name);
        List<PyPiLink> links = assets.stream().map(this::buildPyPiLink).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return PyPiIndexUtils.buildIndexPage(this.templateHelper, name, links);
    }

    private Optional<PyPiLink> buildPyPiLink(FluentAsset asset) {
        NestedAttributesMap pypiAttributes = asset.attributes().child("pypi");
        String uri = asset.path().startsWith("/") ? asset.path().substring(1) : asset.path();
        String file = uri.substring(uri.lastIndexOf(47) + 1);
        Optional<String> md5 = PyPiDataUtils.getMd5(asset);
        if (!md5.isPresent()) {
            return Optional.empty();
        }
        String link = String.format("../../%s#md5=%s", uri, md5.get());
        String dataRequiresPython = (String)pypiAttributes.get("requires_python", String.class, (Object)"");
        return Optional.of(new PyPiLink(file, link, dataRequiresPython));
    }

    private FluentAsset storeWheelAndSignaturePayloads(TempBlobPartPayload wheelPayload, @Nullable TempBlobPartPayload gpgPayload, Map<String, String> attributes) {
        FluentAsset wheelAsset = this.savePyPiWheelPayload(wheelPayload.getName(), attributes, wheelPayload);
        if (gpgPayload != null) {
            this.storeGpgSignaturePayload(gpgPayload, attributes.get("name"), attributes.get("version"));
        }
        return wheelAsset;
    }

    private FluentAsset savePyPiWheelPayload(String filename, Map<String, String> attributes, TempBlobPartPayload wheelPayload) {
        Preconditions.checkNotNull(attributes);
        Preconditions.checkNotNull((Object)wheelPayload);
        Throwable throwable = null;
        Object var5_6 = null;
        try (TempBlob tempBlob = wheelPayload.getTempBlob();){
            String name = (String)Preconditions.checkNotNull((Object)attributes.get("name"));
            PyPiStorageUtils.validateMd5Hash(attributes, tempBlob);
            PyPiIndexFacet indexFacet = (PyPiIndexFacet)this.facet(PyPiIndexFacet.class);
            indexFacet.deleteIndex(name);
            PypiContentFacet contentFacet = (PypiContentFacet)this.facet(PypiContentFacet.class);
            if (!contentFacet.isComponentExists(name)) {
                indexFacet.deleteRootIndex();
            }
            return contentFacet.putWheel(filename, attributes, tempBlob, name).markAsCached((Payload)wheelPayload);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Content storeGpgSignaturePayload(TempBlobPartPayload gpgPayload, String name, String version) {
        PypiContentFacet contentFacet = (PypiContentFacet)this.facet(PypiContentFacet.class);
        if (!contentFacet.isComponentExists(name)) {
            ((PyPiIndexFacet)this.facet(PyPiIndexFacet.class)).deleteRootIndex();
        }
        return contentFacet.putWheelSignature(name, version, gpgPayload);
    }
}

