/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.pypi;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.repository.pypi.PyPiPathUtils;
import com.sonatype.nexus.repository.pypi.datastore.internal.ContentPypiPathUtils;
import com.sonatype.nexus.repository.pypi.internal.PyPiFileUtils;

public class PyPiRestoreUtil {
    public static String extractVersionFromPath(String path) {
        Preconditions.checkNotNull((Object)path);
        String fileName = PyPiFileUtils.extractFilenameFromPath(path);
        if (fileName.length() > 0) {
            return PyPiFileUtils.extractVersionFromFilename(fileName);
        }
        return null;
    }

    public static boolean isIndex(String path) {
        Preconditions.checkNotNull((Object)path);
        return PyPiPathUtils.isIndexPath(path) || PyPiPathUtils.isRootIndexPath(path) || ContentPypiPathUtils.isIndex(path);
    }

    public static boolean isRootIndex(String path) {
        Preconditions.checkNotNull((Object)path);
        return PyPiPathUtils.isRootIndexPath(path) || ContentPypiPathUtils.isRootIndexPath(path);
    }

    private PyPiRestoreUtil() {
    }
}

