/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NexusThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ThreadGroup schedulerThreadGroup;
    private final boolean deamonThread;
    private int threadPriority;

    public NexusThreadFactory(String poolId, String threadGroupName) {
        this(poolId, threadGroupName, 5);
    }

    public NexusThreadFactory(String poolId, String threadGroupName, int threadPriority) {
        this(poolId, threadGroupName, threadPriority, false);
    }

    public NexusThreadFactory(String poolId, String threadGroupName, int threadPriority, boolean daemonThread) {
        int poolNum = poolNumber.getAndIncrement();
        this.schedulerThreadGroup = new ThreadGroup(String.valueOf(threadGroupName) + " #" + poolNum);
        this.namePrefix = String.valueOf(poolId) + "-" + poolNum + "-thread-";
        this.deamonThread = daemonThread;
        this.threadPriority = threadPriority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread result = new Thread(this.schedulerThreadGroup, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement());
        result.setDaemon(this.deamonThread);
        result.setPriority(this.threadPriority);
        return result;
    }
}

