/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.apache.shiro.concurrent.SubjectAwareScheduledExecutorService;
import org.apache.shiro.subject.Subject;
import org.sonatype.nexus.security.subject.CurrentSubjectSupplier;
import org.sonatype.nexus.thread.internal.MDCAwareCallable;
import org.sonatype.nexus.thread.internal.MDCAwareRunnable;

public class NexusScheduledExecutorService
extends SubjectAwareScheduledExecutorService {
    private final Supplier<Subject> subjectSupplier;

    public NexusScheduledExecutorService(ScheduledExecutorService target, Supplier<Subject> subjectSupplier) {
        super((ScheduledExecutorService)Preconditions.checkNotNull((Object)target));
        this.subjectSupplier = (Supplier)Preconditions.checkNotNull(subjectSupplier);
    }

    protected Subject getSubject() {
        return this.subjectSupplier.get();
    }

    protected Runnable associateWithSubject(Runnable r) {
        Subject subject = this.getSubject();
        return subject.associateWith((Runnable)new MDCAwareRunnable(r));
    }

    protected <T> Callable<T> associateWithSubject(Callable<T> task) {
        Subject subject = this.getSubject();
        return subject.associateWith(new MDCAwareCallable<T>(task));
    }

    public static NexusScheduledExecutorService forFixedSubject(ScheduledExecutorService target, Subject subject) {
        return new NexusScheduledExecutorService(target, () -> subject);
    }

    public static NexusScheduledExecutorService forCurrentSubject(ScheduledExecutorService target) {
        return new NexusScheduledExecutorService(target, (Supplier<Subject>)new CurrentSubjectSupplier());
    }
}

