/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.thread;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.FreezeService;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.app.NotWritableException;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.security.subject.FakeAlmightySubject;
import org.sonatype.nexus.thread.NexusExecutorService;
import org.sonatype.nexus.thread.NexusThreadFactory;

@Named
@Singleton
@ManagedLifecycle(phase=ManagedLifecycle.Phase.STORAGE)
public class DatabaseStatusDelayedExecutor
extends StateGuardLifecycleSupport
implements ExecutorService {
    private final FreezeService freezeService;
    private final int delayedExecutorThreadPoolSize;
    private final int sleepInterval;
    private final int maxRetries;
    private ExecutorService executor;

    @Inject
    public DatabaseStatusDelayedExecutor(FreezeService freezeService, @Named(value="${nexus.delayedExecutor.threadPoolSize:-1}") int delayedExecutorThreadPoolSize, @Named(value="${nexus.delayedExecutor.sleepIntervalMs:-5000}") int sleepInterval, @Named(value="${nexus.delayedExecutor.maxRetries:-8640}") int maxRetries) {
        this.freezeService = (FreezeService)Preconditions.checkNotNull((Object)freezeService);
        Preconditions.checkArgument((delayedExecutorThreadPoolSize > 0 ? 1 : 0) != 0, (Object)delayedExecutorThreadPoolSize);
        this.delayedExecutorThreadPoolSize = delayedExecutorThreadPoolSize;
        Preconditions.checkArgument((sleepInterval > 0 ? 1 : 0) != 0, (Object)sleepInterval);
        this.sleepInterval = sleepInterval;
        Preconditions.checkArgument((maxRetries > 0 ? 1 : 0) != 0, (Object)maxRetries);
        this.maxRetries = maxRetries;
    }

    private Runnable wrap(Runnable runnable) {
        Callable<Object> callable = this.wrap(Executors.callable(runnable));
        return () -> {
            try {
                callable.call();
            }
            catch (Exception e) {
                this.log.warn("Unexpected exception running task.", (Throwable)e);
            }
        };
    }

    private <T> Callable<T> wrap(Callable<T> callable) {
        return () -> {
            try {
                int attempt = 0;
                while (attempt < this.maxRetries) {
                    try {
                        this.freezeService.checkWritable("Task needs writable database");
                        return callable.call();
                    }
                    catch (NotWritableException e) {
                        this.log.debug("Waiting for database to become writable.", (Throwable)e);
                        Thread.sleep(this.sleepInterval);
                        ++attempt;
                    }
                }
                this.log.warn("Hit retry limit waiting for a writable database.");
                return callable.call();
            }
            catch (InterruptedException e) {
                this.log.warn("Interrupted while waiting to call task.", (Throwable)e);
                return null;
            }
        };
    }

    @Guarded(by={"NEW"})
    protected void doStart() {
        this.executor = NexusExecutorService.forFixedSubject(Executors.newFixedThreadPool(this.delayedExecutorThreadPoolSize, new NexusThreadFactory("status-delayed-tasks", "status-delayed-tasks")), FakeAlmightySubject.TASK_SUBJECT);
    }

    @Guarded(by={"STARTED"})
    protected void doStop() {
        this.executor.shutdownNow();
        this.executor = null;
    }

    @Override
    @Guarded(by={"STARTED"})
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    @Guarded(by={"STARTED"})
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    @Guarded(by={"STARTED"})
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.wrap(task));
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> Future<T> submit(Runnable task, T result) {
        return this.executor.submit(this.wrap(task), result);
    }

    @Override
    @Guarded(by={"STARTED"})
    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.wrap(task));
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(this.wrapAll(tasks));
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.executor.invokeAny(this.wrapAll(tasks));
    }

    @Override
    @Guarded(by={"STARTED"})
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.executor.invokeAny(this.wrapAll(tasks), timeout, unit);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void execute(Runnable command) {
        this.executor.execute(this.wrap(command));
    }

    @VisibleForTesting
    void setExecutor(ExecutorService testExecutor) {
        this.executor = (ExecutorService)Preconditions.checkNotNull((Object)testExecutor);
    }

    private <T> Collection<? extends Callable<T>> wrapAll(Collection<? extends Callable<T>> tasks) {
        return tasks.stream().map(this::wrap).collect(Collectors.toList());
    }
}

