/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURLBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sonatype.insight.scan.manifest.NpmDependency;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.BomParserFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.parsers.Parser;

public final class NpmDependencies {
    private static final String NAME_FIELD = "name";
    private static final String VERSION_FIELD = "version";
    private static final String DEPENDENCIES_FIELD = "dependencies";
    private static final String DEV_FIELD = "dev";
    private static final String OPTIONAL_FIELD = "optional";
    private static final String DEV_OPTIONAL_FIELD = "devOptional";
    private static final String REQUIRES_FIELD = "requires";
    private static final String PACKAGES_FIELD = "packages";
    private static final String LOCKFILE_VERSION_FIELD = "lockfileVersion";
    private static final String PEER_DEPENDENCIES_FIELD = "peerDependencies";
    private static final String PEER_DEPENDENCIES_META_FIELD = "peerDependenciesMeta";
    public String name;
    public String version;
    public Set<NpmDependency> dependencies = new LinkedHashSet<NpmDependency>();
    public Integer lockfileVersion;

    public static void filterCylicDependencies(NpmDependencies npmDependencies) {
        npmDependencies.dependencies = NpmDependencies.filterCylicDependencies(npmDependencies.dependencies);
    }

    public static Set<NpmDependency> filterCylicDependencies(Set<NpmDependency> npmDependencies) {
        LinkedHashSet<NpmDependency> dependencies = new LinkedHashSet<NpmDependency>();
        for (NpmDependency npmDependency : npmDependencies) {
            NpmDependency copy = NpmDependencies.copyWithoutCyclicDependencies(new HashSet<NpmDependency>(), npmDependency);
            if (copy == null) continue;
            dependencies.add(copy);
        }
        return dependencies;
    }

    public static NpmDependency copyWithoutCyclicDependencies(Set<NpmDependency> processed, NpmDependency npmDependency) {
        if (!processed.add(npmDependency)) {
            return null;
        }
        NpmDependency copy = new NpmDependency(npmDependency.packageId, npmDependency.version);
        copy.requires.putAll(npmDependency.requires);
        for (NpmDependency child : npmDependency.dependencies) {
            NpmDependency childCopy = NpmDependencies.copyWithoutCyclicDependencies(new HashSet<NpmDependency>(processed), child);
            if (childCopy == null) continue;
            copy.dependencies.add(childCopy);
        }
        return copy;
    }

    public static List<NpmDependency> getFlattenedDependencies(Set<NpmDependency> dependencies) {
        return NpmDependencies.getFlattenedDependenciesWithoutCylic(NpmDependencies.filterCylicDependencies(dependencies));
    }

    public static List<NpmDependency> getFlattenedDependenciesWithoutCylic(Set<NpmDependency> dependencies) {
        ArrayList<NpmDependency> result = new ArrayList<NpmDependency>(dependencies);
        for (NpmDependency dependency : dependencies) {
            if (dependency.dependencies.isEmpty()) continue;
            result.addAll(NpmDependencies.getFlattenedDependencies(dependency.dependencies));
        }
        return result;
    }

    public static class NpmDependenciesCyloneDxBomDeserializer {
        public NpmDependencies deserialize(String xml) {
            try {
                byte[] bytes = xml.getBytes(StandardCharsets.UTF_8);
                Parser parser = BomParserFactory.createParser((byte[])bytes);
                Bom bom = parser.parse(bytes);
                Component rootComponent = bom.getMetadata().getComponent();
                NpmDependencies npmDependencies = new NpmDependencies();
                npmDependencies.name = rootComponent.getName();
                npmDependencies.version = rootComponent.getVersion();
                if (bom.getComponents() != null) {
                    for (Component component : bom.getComponents()) {
                        npmDependencies.dependencies.add(new NpmDependency(component.getName(), component.getVersion()));
                    }
                }
                return npmDependencies;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    public static class NpmDependenciesCyloneDxBomSerializer {
        public String serialize(NpmDependencies npmDependencies) {
            try {
                Bom bom = new Bom();
                Component rootComponent = new Component();
                rootComponent.setType(Component.Type.APPLICATION);
                rootComponent.setName(npmDependencies.name);
                rootComponent.setVersion(npmDependencies.version);
                Metadata metadata = new Metadata();
                metadata.setTimestamp(null);
                metadata.setComponent(rootComponent);
                bom.setMetadata(metadata);
                LinkedHashMap<String, Component> componentByPurl = new LinkedHashMap<String, Component>();
                for (NpmDependency npmDependency : npmDependencies.dependencies) {
                    this.populateComponentByPurl(componentByPurl, npmDependency);
                }
                componentByPurl.values().forEach(arg_0 -> ((Bom)bom).addComponent(arg_0));
                BomXmlGenerator xmlGenerator = BomGeneratorFactory.createXml((CycloneDxSchema.Version)CycloneDxSchema.Version.VERSION_13, (Bom)bom);
                xmlGenerator.generate();
                return xmlGenerator.toXmlString();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        private void populateComponentByPurl(Map<String, Component> componentByPurl, NpmDependency npmDependency) {
            String purl = this.toPurl(npmDependency);
            if (purl == null || componentByPurl.containsKey(purl)) {
                return;
            }
            Component component = new Component();
            component.setType(Component.Type.LIBRARY);
            component.setName(npmDependency.packageId);
            component.setVersion(npmDependency.version);
            componentByPurl.put(purl, component);
            for (NpmDependency child : npmDependency.dependencies) {
                this.populateComponentByPurl(componentByPurl, child);
            }
        }

        private String toPurl(NpmDependency npmDependency) {
            try {
                return PackageURLBuilder.aPackageURL().withType("npm").withName(npmDependency.packageId).withVersion(npmDependency.version).build().canonicalize();
            }
            catch (MalformedPackageURLException e) {
                return null;
            }
        }
    }

    public static class NpmDependenciesSerializer {
        public JsonElement serialize(NpmDependencies src) {
            JsonObject result = new JsonObject();
            if (src != null) {
                this.addElementIfNotNull(result, src.name, NpmDependencies.NAME_FIELD);
                this.addElementIfNotNull(result, src.version, NpmDependencies.VERSION_FIELD);
                if (!src.dependencies.isEmpty()) {
                    JsonObject packages = new JsonObject();
                    for (NpmDependency npmDependency : src.dependencies) {
                        this.addPackage(new HashSet<NpmDependency>(), packages, npmDependency);
                    }
                    result.add(NpmDependencies.DEPENDENCIES_FIELD, (JsonElement)packages);
                }
            }
            return result;
        }

        private void addElementIfNotNull(JsonObject result, String value, String fieldName) {
            if (value != null) {
                result.add(fieldName, (JsonElement)new JsonPrimitive(value));
            }
        }

        private void addPackage(Set<NpmDependency> processed, JsonObject packages, NpmDependency npmDependency) {
            if (!processed.add(npmDependency)) {
                return;
            }
            JsonObject packageObject = new JsonObject();
            packageObject.addProperty(NpmDependencies.VERSION_FIELD, npmDependency.version);
            if (!npmDependency.dependencies.isEmpty()) {
                JsonObject childrenPackages = new JsonObject();
                for (NpmDependency childNpmDependency : npmDependency.dependencies) {
                    this.addPackage(new HashSet<NpmDependency>(processed), childrenPackages, childNpmDependency);
                }
                packageObject.add(NpmDependencies.DEPENDENCIES_FIELD, (JsonElement)childrenPackages);
            }
            packages.add(npmDependency.packageId, (JsonElement)packageObject);
        }
    }

    public static class NpmDependenciesDeserializer {
        public NpmDependencies deserialize(JsonElement json) {
            JsonElement lockfileVersionElement;
            JsonElement versionElement;
            NpmDependencies npmDependencies = new NpmDependencies();
            JsonElement nameElement = json.getAsJsonObject().get(NpmDependencies.NAME_FIELD);
            if (nameElement != null) {
                npmDependencies.name = nameElement.getAsString();
            }
            if ((versionElement = json.getAsJsonObject().get(NpmDependencies.VERSION_FIELD)) != null) {
                npmDependencies.version = versionElement.getAsString();
            }
            int lockfileVersion = (lockfileVersionElement = json.getAsJsonObject().get(NpmDependencies.LOCKFILE_VERSION_FIELD)) == null ? 1 : lockfileVersionElement.getAsInt();
            npmDependencies.lockfileVersion = lockfileVersion;
            if (lockfileVersion <= 1) {
                JsonElement dependenciesElement = json.getAsJsonObject().get(NpmDependencies.DEPENDENCIES_FIELD);
                if (dependenciesElement != null) {
                    npmDependencies.dependencies = this.deserializeDependencies(dependenciesElement);
                }
            } else {
                JsonElement packagesElement = json.getAsJsonObject().get(NpmDependencies.PACKAGES_FIELD);
                if (packagesElement != null) {
                    npmDependencies.dependencies = this.deserializePackages(packagesElement);
                }
            }
            return npmDependencies;
        }

        private Map<String, String> deserializeRequires(JsonElement requiresElement) {
            HashMap<String, String> requires = new HashMap<String, String>();
            JsonObject requiresObject = requiresElement.getAsJsonObject();
            for (Map.Entry require : requiresObject.entrySet()) {
                requires.put((String)require.getKey(), ((JsonElement)require.getValue()).getAsString());
            }
            return requires;
        }

        private boolean isOptionalOrDevDependency(JsonObject packageObject) {
            if (packageObject.get(NpmDependencies.DEV_FIELD) != null && packageObject.get(NpmDependencies.DEV_FIELD).getAsBoolean()) {
                return true;
            }
            if (packageObject.get(NpmDependencies.DEV_OPTIONAL_FIELD) != null && packageObject.get(NpmDependencies.DEV_OPTIONAL_FIELD).getAsBoolean()) {
                return true;
            }
            return packageObject.get(NpmDependencies.OPTIONAL_FIELD) != null && packageObject.get(NpmDependencies.OPTIONAL_FIELD).getAsBoolean();
        }

        private Set<NpmDependency> deserializePackages(JsonElement packagesElement) {
            LinkedHashMap<String, NpmDependency> allNpmDependencies = new LinkedHashMap<String, NpmDependency>();
            LinkedHashSet<NpmDependency> npmDependencies = new LinkedHashSet<NpmDependency>();
            JsonObject packagesObject = packagesElement.getAsJsonObject();
            for (String packagePath : packagesObject.keySet()) {
                JsonElement childrenPeerDependenciesElement;
                JsonElement versionElement;
                String version;
                JsonObject packageObject;
                if (packagePath == null || packagePath.isEmpty() || this.isOptionalOrDevDependency(packageObject = packagesObject.get(packagePath).getAsJsonObject()) || (version = (versionElement = packageObject.get(NpmDependencies.VERSION_FIELD)) == null || versionElement instanceof JsonNull ? null : versionElement.getAsString()) == null || version.isEmpty()) continue;
                String packageId = this.extractPackageIdFromPath(packagePath);
                NpmDependency npmDependency = allNpmDependencies.computeIfAbsent(packageId + "@" + version, key -> new NpmDependency(packageId, version));
                JsonElement childrenDependenciesElement = packageObject.get(NpmDependencies.DEPENDENCIES_FIELD);
                if (childrenDependenciesElement != null) {
                    npmDependency.dependencies.addAll(this.deserializePackagesDependencies(packagePath, packagesObject, childrenDependenciesElement, allNpmDependencies));
                }
                if ((childrenPeerDependenciesElement = packageObject.get(NpmDependencies.PEER_DEPENDENCIES_FIELD)) != null) {
                    JsonElement childrenPeerDependenciesMetaElement = packageObject.get(NpmDependencies.PEER_DEPENDENCIES_META_FIELD);
                    if (childrenPeerDependenciesMetaElement != null) {
                        childrenPeerDependenciesElement = this.filterOutOptionalPeerDependencies(childrenPeerDependenciesElement, childrenPeerDependenciesMetaElement);
                    }
                    npmDependency.dependencies.addAll(this.deserializePackagesDependencies(packagePath, packagesObject, childrenPeerDependenciesElement, allNpmDependencies));
                }
                npmDependencies.add(npmDependency);
            }
            return npmDependencies;
        }

        private JsonElement filterOutOptionalPeerDependencies(JsonElement childrenPeerDependenciesElement, JsonElement childrenPeerDependenciesMetaElement) {
            Set optionalChildrenPeerDependenciesElements = childrenPeerDependenciesMetaElement.getAsJsonObject().entrySet().stream().filter(e -> {
                JsonElement value = (JsonElement)e.getValue();
                if (value == null || !value.isJsonObject()) {
                    return false;
                }
                JsonElement optional = value.getAsJsonObject().get(NpmDependencies.OPTIONAL_FIELD);
                if (optional == null || !optional.isJsonPrimitive()) {
                    return false;
                }
                return optional.getAsBoolean();
            }).map(Map.Entry::getKey).collect(Collectors.toSet());
            JsonObject filteredChildrenPeerDependenciesElement = new JsonObject();
            childrenPeerDependenciesElement.getAsJsonObject().entrySet().stream().filter(e -> !optionalChildrenPeerDependenciesElements.contains(e.getKey())).forEach(e -> filteredChildrenPeerDependenciesElement.add((String)e.getKey(), (JsonElement)e.getValue()));
            return filteredChildrenPeerDependenciesElement;
        }

        private Collection<NpmDependency> deserializePackagesDependencies(String packagePath, JsonObject packagesObject, JsonElement packageDependenciesElement, Map<String, NpmDependency> allNpmDependencies) {
            LinkedHashSet<NpmDependency> npmDependencies = new LinkedHashSet<NpmDependency>();
            JsonObject packagesDependenciesObject = packageDependenciesElement.getAsJsonObject();
            for (String packageId : packagesDependenciesObject.keySet()) {
                String version = this.extractVersion(packagePath, packagesObject, packageId);
                if (version == null) continue;
                NpmDependency npmDependency = allNpmDependencies.computeIfAbsent(packageId + "@" + version, key -> new NpmDependency(packageId, version));
                npmDependencies.add(npmDependency);
            }
            return npmDependencies;
        }

        private String extractVersion(String packagePath, JsonObject packagesObject, String packageId) {
            List<String> packagePathSplit = Arrays.asList(packagePath.split("node_modules"));
            for (int i = packagePathSplit.size(); i >= 1; --i) {
                String dependencyPackagePath = String.join((CharSequence)"node_modules", packagePathSplit.subList(0, i));
                dependencyPackagePath = dependencyPackagePath + (dependencyPackagePath.endsWith("/") ? "" : "/") + "node_modules/" + packageId;
                JsonElement dependencyPackageObject = packagesObject.get(dependencyPackagePath = dependencyPackagePath.substring(dependencyPackagePath.startsWith("/") ? 1 : 0));
                if (dependencyPackageObject == null || dependencyPackageObject.getAsJsonObject().get(NpmDependencies.VERSION_FIELD) == null) continue;
                return dependencyPackageObject.getAsJsonObject().get(NpmDependencies.VERSION_FIELD).getAsString();
            }
            return null;
        }

        private String extractPackageIdFromPath(String packagePath) {
            String nodeModulesWithForwardSlash = "node_modules/";
            int index = packagePath.lastIndexOf(nodeModulesWithForwardSlash);
            if (index == -1) {
                return packagePath;
            }
            return packagePath.substring(index + nodeModulesWithForwardSlash.length());
        }

        private Set<NpmDependency> deserializeDependencies(JsonElement dependenciesElement) {
            LinkedHashSet<NpmDependency> npmDependencies = new LinkedHashSet<NpmDependency>();
            JsonObject dependenciesObject = dependenciesElement.getAsJsonObject();
            for (String packageId : dependenciesObject.keySet()) {
                JsonElement childrenDependenciesElement;
                JsonElement versionElement;
                String version;
                JsonObject packageObject;
                if (packageId == null || packageId.isEmpty() || (packageObject = dependenciesObject.get(packageId).getAsJsonObject()).get(NpmDependencies.DEV_FIELD) != null && packageObject.get(NpmDependencies.DEV_FIELD).getAsBoolean() || (version = (versionElement = packageObject.get(NpmDependencies.VERSION_FIELD)) == null || versionElement instanceof JsonNull ? null : versionElement.getAsString()) == null || version.isEmpty()) continue;
                NpmDependency npmDependency = new NpmDependency(packageId, version);
                JsonElement requiresElement = packageObject.get(NpmDependencies.REQUIRES_FIELD);
                if (requiresElement != null) {
                    npmDependency.requires.putAll(this.deserializeRequires(requiresElement));
                }
                if ((childrenDependenciesElement = packageObject.get(NpmDependencies.DEPENDENCIES_FIELD)) != null) {
                    npmDependency.dependencies.addAll(this.deserializeDependencies(childrenDependenciesElement));
                }
                npmDependencies.add(npmDependency);
            }
            return npmDependencies;
        }
    }
}

