/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.sonatype.insight.scan.manifest.DrupalDependency;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class DrupalFile {
    private final Set<DrupalDependency> dependencies = new LinkedHashSet<DrupalDependency>();

    public DrupalFile(List<String> contents) {
        this.filterDependencies(contents);
    }

    public static DrupalFile fromContents(List<String> contents) {
        return new DrupalFile(contents);
    }

    private void filterDependencies(List<String> contents) {
        ListIterator<String> iterator = contents.listIterator();
        while (iterator.hasNext()) {
            String line = iterator.next().trim();
            DrupalDependency dependency = DrupalDependency.fromContent(line);
            if (dependency == null) continue;
            this.dependencies.add(dependency);
        }
    }

    public Set<DrupalDependency> getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<DrupalDependency> it = this.dependencies.iterator();
        while (it.hasNext()) {
            DrupalDependency dependency = it.next();
            sb.append(dependency.toString());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

