/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import java.util.EnumSet;

public enum ConanDependencyCategory {
    REQUIRES("[requires]"),
    BUILD_REQUIRES("[build_requires]"),
    GENERATORS("[generators]"),
    OPTIONS("[options]"),
    IMPORTS("[imports]"),
    SETTINGS("[settings]"),
    RECIPE_HASH("[recipe_hash]"),
    ENV("[env]"),
    FULL_REQUIRES("[full_requires]"),
    FULL_OPTIONS("[full_options]"),
    FULL_SETTINGS("[full_settings]");

    public final String categoryMarker;

    private ConanDependencyCategory(String categoryMarker) {
        this.categoryMarker = categoryMarker;
    }

    public static ConanDependencyCategory fromString(String categoryMarker) {
        if (categoryMarker != null) {
            for (ConanDependencyCategory category : EnumSet.allOf(ConanDependencyCategory.class)) {
                if (!category.categoryMarker.equals(categoryMarker)) continue;
                return category;
            }
        }
        return null;
    }
}

