/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.insight.scan.manifest;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sonatype.insight.scan.manifest.BowerDependency;
import java.util.LinkedHashSet;
import java.util.Set;

public final class BowerDependencies {
    private static final String EQUAL_OPERATOR = "=";
    public Set<BowerDependency> dependencies = new LinkedHashSet<BowerDependency>();

    public static class BowerDependenciesSerializer {
        public JsonElement serialize(BowerDependencies src) {
            JsonObject jsonObject = new JsonObject();
            for (BowerDependency dependency : src.dependencies) {
                String version = dependency.hasEqual ? BowerDependencies.EQUAL_OPERATOR + dependency.version : dependency.version;
                jsonObject.addProperty(dependency.name, version);
            }
            JsonObject result = new JsonObject();
            result.add("dependencies", (JsonElement)jsonObject);
            return result;
        }
    }

    public static class BowerDependenciesDeserializer {
        public BowerDependencies deserialize(JsonElement json) {
            BowerDependencies bowerDependencies = new BowerDependencies();
            JsonElement dependencies = json.getAsJsonObject().get("dependencies");
            if (dependencies != null) {
                JsonObject jsonObject = dependencies.getAsJsonObject();
                for (String key : jsonObject.keySet()) {
                    String version = jsonObject.get(key).getAsString();
                    bowerDependencies.dependencies.add(new BowerDependency(key, version.replaceFirst(BowerDependencies.EQUAL_OPERATOR, ""), version.startsWith(BowerDependencies.EQUAL_OPERATOR)));
                }
            }
            return bowerDependencies;
        }
    }
}

