/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTIdentifierAccess;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.selector.CselToSql;
import org.sonatype.nexus.selector.ParserVisitorSupport;
import org.sonatype.nexus.selector.SelectorSqlBuilder;

@Named(value="mybatis")
@Singleton
public class DatastoreCselToSql
extends ParserVisitorSupport
implements CselToSql {
    private static final String EXPECTED_STRING_LITERAL = "Expected string literal";

    @Override
    public void transformCselToSql(ASTJexlScript script, SelectorSqlBuilder builder) {
        script.childrenAccept((ParserVisitor)this, (Object)builder);
    }

    @Override
    protected Object doVisit(JexlNode node, Object data) {
        throw new JexlException(node, "Expression not supported in CSEL selector, failing node is " + node.jexlInfo().toString());
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        return this.transformOperator((JexlNode)node, "or", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return this.transformOperator((JexlNode)node, "and", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return this.transformOperator((JexlNode)node, "=", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        return this.transformMatchesOperator((JexlNode)node, "~", (SelectorSqlBuilder)data);
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformStartsWithOperator(leftChild, (ASTStringLiteral)rightChild, (SelectorSqlBuilder)data);
        } else if (leftChild instanceof ASTStringLiteral) {
            this.transformStartsWithOperator(rightChild, (ASTStringLiteral)leftChild, (SelectorSqlBuilder)data);
        } else {
            throw new JexlException((JexlNode)node, EXPECTED_STRING_LITERAL);
        }
        return data;
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        if (rightChild instanceof ASTStringLiteral) {
            this.transformNotEqualsOperator(leftChild, (ASTStringLiteral)rightChild, (SelectorSqlBuilder)data);
        } else if (leftChild instanceof ASTStringLiteral) {
            this.transformNotEqualsOperator(rightChild, (ASTStringLiteral)leftChild, (SelectorSqlBuilder)data);
        } else {
            throw new JexlException((JexlNode)node, EXPECTED_STRING_LITERAL);
        }
        return data;
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        ((SelectorSqlBuilder)data).appendExpression(() -> {
            Object object2 = node.childrenAccept((ParserVisitor)this, data);
        });
        return data;
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        ((SelectorSqlBuilder)data).appendLiteral(node.getLiteral());
        return data;
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        ((SelectorSqlBuilder)data).appendProperty(node.getName());
        return data;
    }

    @Override
    protected Object visit(ASTReference node, Object data) {
        ASTIdentifierAccess subRef = (ASTIdentifierAccess)node.jjtGetChild(1);
        ((SelectorSqlBuilder)data).appendProperty(subRef.getName());
        return data;
    }

    protected SelectorSqlBuilder transformOperator(JexlNode node, String operator, SelectorSqlBuilder builder) {
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        leftChild.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperator(operator);
        rightChild.jjtAccept((ParserVisitor)this, (Object)builder);
        return builder;
    }

    protected SelectorSqlBuilder transformMatchesOperator(JexlNode node, String operator, SelectorSqlBuilder builder) {
        String pattern;
        JexlNode leftChild = node.jjtGetChild(0);
        JexlNode rightChild = node.jjtGetChild(1);
        leftChild.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperator(operator);
        if (rightChild instanceof ASTStringLiteral) {
            pattern = ((ASTStringLiteral)rightChild).getLiteral();
            if (pattern.charAt(0) != '^') {
                pattern = "^(" + pattern + ")$";
            }
        } else {
            throw new JexlException(node, EXPECTED_STRING_LITERAL);
        }
        builder.appendLiteral(pattern);
        return builder;
    }

    private SelectorSqlBuilder transformStartsWithOperator(JexlNode node, ASTStringLiteral literal, SelectorSqlBuilder builder) {
        node.jjtAccept((ParserVisitor)this, (Object)builder);
        builder.appendOperator("like");
        builder.appendLiteral(String.valueOf(literal.getLiteral()) + '%');
        return builder;
    }

    private SelectorSqlBuilder transformNotEqualsOperator(JexlNode node, ASTStringLiteral literal, SelectorSqlBuilder builder) {
        builder.appendExpression(() -> {
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperator("is null or");
            node.jjtAccept((ParserVisitor)this, (Object)builder);
            builder.appendOperator("<>");
            literal.jjtAccept((ParserVisitor)this, (Object)builder);
        });
        return builder;
    }
}

