/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.selector.VariableResolver;

public class VariableSource {
    private final List<VariableResolver> resolvers;
    private final Set<String> variableSet;

    public VariableSource(List<VariableResolver> resolvers) {
        this.resolvers = Collections.unmodifiableList(resolvers);
        Set variables = resolvers.stream().map(VariableResolver::getVariableSet).flatMap(Collection::stream).collect(Collectors.toSet());
        this.variableSet = Collections.unmodifiableSet(variables);
    }

    public Optional<Object> get(String variable) {
        return this.resolvers.stream().map(vr -> vr.resolve(variable)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Set<String> getVariableSet() {
        return this.variableSet;
    }
}

