/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.sonatype.nexus.selector.VariableResolver;

public class PropertiesResolver<V>
implements VariableResolver {
    private final String namespace;
    private final Map<String, V> map;
    private final Set<String> variableSet;

    public PropertiesResolver(String namespace, Properties properties) {
        this(namespace, PropertiesResolver.propertiesToMap(properties));
    }

    public PropertiesResolver(String namespace, Map<String, V> properties) {
        this.namespace = namespace;
        this.map = Collections.unmodifiableMap(properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(namespace) + "." + (String)e.getKey(), Map.Entry::getValue)));
        this.variableSet = Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public Optional<Object> resolve(String variable) {
        if (this.map.containsKey(variable)) {
            return Optional.of(this.map.get(variable));
        }
        return Optional.empty();
    }

    public String getNamespace() {
        return this.namespace;
    }

    private static <V> Map<String, V> propertiesToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue()));
    }

    @Override
    public Set<String> getVariableSet() {
        return this.variableSet;
    }
}

