/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import java.lang.reflect.Method;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.Node;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.selector.LeadingSlashRegexTransformer;
import org.sonatype.nexus.selector.ParserVisitorSupport;

class LeadingSlashScriptTransformer
extends ParserVisitorSupport {
    private static final LeadingSlashScriptTransformer INSTANCE = new LeadingSlashScriptTransformer();
    private static final String PATH = "path";
    private final Method setLiteralMethod = this.discoverSetLiteralMethod();

    public static ASTJexlScript trimLeadingSlashes(ASTJexlScript script) {
        if (LeadingSlashScriptTransformer.INSTANCE.setLiteralMethod != null) {
            script.childrenAccept((ParserVisitor)INSTANCE, null);
        }
        return script;
    }

    private LeadingSlashScriptTransformer() {
    }

    @Override
    protected Object doVisit(JexlNode node, Object data) {
        if (node.jjtGetNumChildren() == 2) {
            JexlNode rightChild;
            JexlNode leftChild = node.jjtGetChild(0);
            if (this.isPathExpression((Node)leftChild, (Node)(rightChild = node.jjtGetChild(1)))) {
                this.transformPathLiteral((ASTStringLiteral)rightChild);
            } else if (this.isPathExpression((Node)rightChild, (Node)leftChild)) {
                this.transformPathLiteral((ASTStringLiteral)leftChild);
            } else {
                leftChild.jjtAccept((ParserVisitor)this, data);
                rightChild.jjtAccept((ParserVisitor)this, data);
            }
        } else {
            node.childrenAccept((ParserVisitor)this, data);
        }
        return data;
    }

    private boolean isPathExpression(Node identifier, Node literal) {
        return identifier instanceof ASTIdentifier && PATH.equals(((ASTIdentifier)identifier).getName()) && literal instanceof ASTStringLiteral;
    }

    private void transformPathLiteral(ASTStringLiteral node) {
        String path = node.getLiteral();
        String transformedPath = LeadingSlashRegexTransformer.trimLeadingSlashes(path);
        if (!transformedPath.equals(path)) {
            try {
                this.setLiteralMethod.invoke((Object)node, transformedPath);
            }
            catch (Exception | LinkageError e) {
                this.log.warn("Cannot replace leading slash in path selector {} with {}", new Object[]{path, transformedPath, e});
            }
        }
    }

    private Method discoverSetLiteralMethod() {
        Method _setLiteralMethod;
        try {
            _setLiteralMethod = ASTStringLiteral.class.getDeclaredMethod("setLiteral", String.class);
            _setLiteralMethod.setAccessible(true);
        }
        catch (Exception | LinkageError e) {
            this.log.warn("Cannot modify ASTStringLiterals, leading slashes in path selectors won't be replaced", e);
            _setLiteralMethod = null;
        }
        return _setLiteralMethod;
    }
}

