/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.introspection.JexlUberspect;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.sonatype.nexus.selector.JexlExpression;
import org.sonatype.nexus.selector.LeadingSlashScriptTransformer;
import org.sonatype.nexus.selector.internal.SandboxJexlUberspect;

public class JexlEngine
extends Engine {
    private static final JexlInfo CALLER_INFO = new JexlInfo("Selector", 0, 0);
    private static final Pattern JEXL_CONDENSED_INFO_HEADER = Pattern.compile("Selector@\\d+(?::\\d+)?(?:![\\d+,\\d+]:)? *");

    public JexlEngine() {
        super(new JexlBuilder().uberspect((JexlUberspect)new SandboxJexlUberspect()));
    }

    public ASTJexlScript parseExpression(String expression) {
        String source = this.trimSource((CharSequence)Preconditions.checkNotNull((Object)expression));
        return this.parse(CALLER_INFO, source, null, false, true);
    }

    public JexlExpression buildExpression(String expression, boolean shouldTrimLeadingSlash) {
        ASTJexlScript script = this.parseExpression(expression);
        if (shouldTrimLeadingSlash) {
            script = LeadingSlashScriptTransformer.trimLeadingSlashes(script);
        }
        return new JexlExpression(this, expression, script);
    }

    public static String expandExceptionDetail(JexlException e) {
        StringBuilder detailBuilder = new StringBuilder(e.getMessage());
        JexlInfo info = e.getInfo();
        if (info != null) {
            Optional<String> detail;
            Matcher matcher = JEXL_CONDENSED_INFO_HEADER.matcher(detailBuilder);
            if (matcher.find()) {
                detailBuilder.delete(matcher.start(), matcher.end());
            }
            if ((detail = Optional.ofNullable(info.getDetail()).map(Object::toString)).isPresent() && detailBuilder.indexOf(detail.get()) < 0) {
                JexlEngine.addContext(detailBuilder, String.format("in '%s'", detail.get()));
            }
            JexlEngine.addContext(detailBuilder, String.format("at line %d column %d", info.getLine(), info.getColumn()));
        }
        return detailBuilder.toString();
    }

    private static StringBuilder addContext(StringBuilder detailBuilder, String context) {
        if (detailBuilder.length() > 0) {
            detailBuilder.append(' ');
        }
        return detailBuilder.append(context);
    }
}

