/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.selector;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.parser.ASTAndNode;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTERNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTJexlScript;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTOrNode;
import org.apache.commons.jexl3.parser.ASTReferenceExpression;
import org.apache.commons.jexl3.parser.ASTSWNode;
import org.apache.commons.jexl3.parser.ASTStringLiteral;
import org.apache.commons.jexl3.parser.JexlNode;
import org.apache.commons.jexl3.parser.ParserVisitor;
import org.sonatype.nexus.selector.ParserVisitorSupport;

class CselValidator
extends ParserVisitorSupport {
    private static final CselValidator INSTANCE = new CselValidator();
    private static final Set<String> VALID_IDENTIFIERS = ImmutableSet.of((Object)"format", (Object)"path");
    private static final String EMBEDDED_STRING_MESSAGE = "String literal '%s' should not contain embedded string (\" or ')";
    private static final String BAD_IDENTIFIER_MESSAGE = "Invalid identifier %s, expected one of " + VALID_IDENTIFIERS;

    public static void validateCselExpression(ASTJexlScript script) {
        script.childrenAccept((ParserVisitor)INSTANCE, null);
    }

    private CselValidator() {
    }

    @Override
    protected Object doVisit(JexlNode node, Object data) {
        throw new JexlException(node, "Expression not supported in CSEL selector");
    }

    @Override
    protected Object visit(ASTOrNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTAndNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTEQNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTNENode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTERNode node, Object data) {
        try {
            Pattern.compile(node.jjtGetChild(1).toString());
            return node.childrenAccept((ParserVisitor)this, data);
        }
        catch (PatternSyntaxException e) {
            throw new JexlException((JexlNode)node, e.getDescription());
        }
    }

    @Override
    protected Object visit(ASTSWNode node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTReferenceExpression node, Object data) {
        return node.childrenAccept((ParserVisitor)this, data);
    }

    @Override
    protected Object visit(ASTStringLiteral node, Object data) {
        String literal = node.getLiteral();
        if (!literal.contains("\"") && !literal.contains("'")) {
            return node.childrenAccept((ParserVisitor)this, data);
        }
        throw new JexlException((JexlNode)node, String.format(EMBEDDED_STRING_MESSAGE, literal));
    }

    @Override
    protected Object visit(ASTIdentifier node, Object data) {
        String id = node.getName();
        if (VALID_IDENTIFIERS.contains(id)) {
            return node.childrenAccept((ParserVisitor)this, data);
        }
        throw new JexlException((JexlNode)node, String.format(BAD_IDENTIFIER_MESSAGE, id));
    }
}

