/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.repository.cocoapods.orient.tasks;

import com.google.common.base.Preconditions;
import com.google.common.collect.Streams;
import com.sonatype.nexus.repository.cocoapods.internal.CocoapodsFormat;
import com.sonatype.nexus.repository.cocoapods.internal.PathUtils;
import com.sonatype.nexus.repository.cocoapods.internal.proxy.InvalidSpecFileException;
import com.sonatype.nexus.repository.cocoapods.internal.proxy.SpecFileProcessor;
import com.sonatype.nexus.repository.cocoapods.orient.upgrade.CocoapodsUpgrade_1_1;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.scheduling.Cancelable;
import org.sonatype.nexus.scheduling.TaskSupport;

@Named
public class CocoapodsStoreRemoteUrlInAttributesTask
extends TaskSupport
implements Cancelable {
    private static final int SPEC_ASSET_PATH_NAME_INDEX = 4;
    private static final int SPEC_ASSET_PATH_VERSION_INDEX = 5;
    private final Path markerFile;
    private final RepositoryManager repositoryManager;
    private final SpecFileProcessor specFileProcessor;

    @Inject
    public CocoapodsStoreRemoteUrlInAttributesTask(ApplicationDirectories directories, RepositoryManager repositoryManager, SpecFileProcessor specFileProcessor) {
        this.markerFile = new File(directories.getWorkDirectory("db"), CocoapodsUpgrade_1_1.MARKER_FILE).toPath();
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.specFileProcessor = specFileProcessor;
    }

    protected Object execute() throws Exception {
        List<Repository> repositories = this.getCocoapodsRepositories();
        repositories.forEach(repository -> {
            StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
            Throwable throwable = null;
            Object var4_5 = null;
            try (StorageTx tx = (StorageTx)storageFacet.txSupplier().get();){
                tx.begin();
                this.updateRepositoryData(tx, (Repository)repository);
                tx.commit();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        });
        if (Files.exists(this.markerFile, new LinkOption[0])) {
            Files.delete(this.markerFile);
        }
        return null;
    }

    public String getMessage() {
        return "Cocoapod. Store remoteDownloadURL in SPEC attributes, update pod assets name.";
    }

    private List<Repository> getCocoapodsRepositories() {
        return Streams.stream((Iterable)this.repositoryManager.browse()).filter(r -> {
            if (r.getFormat() instanceof CocoapodsFormat && r.getType().getValue().equals("proxy")) {
                this.log.debug("Looking at Cocoapods repository: {}", r);
                return true;
            }
            return false;
        }).collect(Collectors.toList());
    }

    private void updateRepositoryData(StorageTx tx, Repository repository) {
        this.log.debug("Update nested assets in {}", (Object)repository.getName());
        this.getSpecFiles(tx, repository).forEach(asset -> {
            try {
                this.log.debug("Update package {}", (Object)asset.name());
                this.updateCocoapodsPackage(tx, (Asset)asset, repository);
            }
            catch (InvalidSpecFileException ise) {
                this.log.warn("Invalid spec file: {}; {}", (Object)asset.name(), (Object)ise.getMessage());
                tx.deleteAsset(asset);
            }
            catch (Exception e) {
                this.log.error("error updating package: " + asset.name(), (Throwable)e);
            }
        });
    }

    private void updateCocoapodsPackage(StorageTx tx, Asset specAsset, Repository repository) throws IOException, InvalidSpecFileException {
        String remoteDownloadURL = this.extractRemoteDownloadURL(tx, specAsset);
        specAsset.formatAttributes().set("ccp_remote", (Object)remoteDownloadURL);
        tx.saveAsset(specAsset);
        CocoapodsCoords coords = this.parseSpecPath(specAsset.name());
        this.updatePodFile(tx, repository, coords, remoteDownloadURL);
    }

    private void updatePodFile(StorageTx tx, Repository repository, CocoapodsCoords coords, String remoteDownloadURL) {
        Asset podAsset = this.findPodFile(tx, repository, coords).orElse(null);
        if (podAsset != null) {
            String podPath = PathUtils.buildNxrmPodPath(coords.name, coords.version, URI.create(remoteDownloadURL));
            this.log.debug("Update pod: {}", (Object)podPath);
            podAsset.name(podPath);
            tx.saveAsset(podAsset);
        }
    }

    private String extractRemoteDownloadURL(StorageTx tx, Asset specAsset) throws InvalidSpecFileException, IOException {
        String specContent;
        Blob spec = tx.requireBlob(specAsset.requireBlobRef());
        Throwable throwable = null;
        Object var6_6 = null;
        try (InputStream is = spec.getInputStream();){
            specContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return this.specFileProcessor.extractExternalUri(specContent).toString();
    }

    private Iterable<Asset> getSpecFiles(StorageTx tx, Repository repository) {
        Query.Builder builder = Query.builder().where("name").like((Object)"Specs/%");
        Query query = builder.build();
        return tx.browseAssets(query, tx.findBucket(repository));
    }

    private Optional<Asset> findPodFile(StorageTx tx, Repository repository, CocoapodsCoords coords) {
        String nameTerm = String.valueOf(String.format("pods/%s/%s/", coords.name, coords.version)) + "%";
        Query.Builder builder = Query.builder().where("name").like((Object)nameTerm);
        Query query = builder.build();
        return Streams.stream((Iterable)tx.browseAssets(query, tx.findBucket(repository))).findAny();
    }

    private CocoapodsCoords parseSpecPath(String specPath) throws InvalidSpecFileException {
        String[] segments = specPath.split("/");
        if (segments.length != 7) {
            throw new InvalidSpecFileException("Invalid Spec file name: " + specPath);
        }
        return new CocoapodsCoords(segments[4], segments[5]);
    }

    private static class CocoapodsCoords {
        private final String name;
        private final String version;

        CocoapodsCoords(String name, String version) {
            this.name = name;
            this.version = version;
        }
    }
}

